/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.assistant.deployment.spi;

import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.console.ConsoleCommand;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public final class AssistantConsoleBuildItem
extends MultiBuildItem {
    private final ConsoleCommand consoleCommand;
    private final String description;
    private final char key;
    private final Optional<String> systemMessage;
    private final String userMessage;
    private final Supplier<String> colorSupplier;
    private final Supplier<String> stateSupplier;
    private final Map<String, String> variables;
    private final Optional<Function<Assistant, CompletionStage<?>>> function;

    public AssistantConsoleBuildItem(ConsoleCommand consoleCommand) {
        this.consoleCommand = consoleCommand;
        this.function = Optional.empty();
        this.description = consoleCommand.getDescription();
        this.key = consoleCommand.getKey();
        this.systemMessage = Optional.empty();
        this.userMessage = null;
        this.colorSupplier = consoleCommand.getHelpState().getColorSupplier();
        this.stateSupplier = consoleCommand.getHelpState().getStateSupplier();
        this.variables = Map.of();
    }

    private AssistantConsoleBuildItem(Builder builder) {
        this.description = builder.description;
        this.key = builder.key;
        this.systemMessage = builder.systemMessage;
        this.userMessage = builder.userMessage;
        this.colorSupplier = builder.colorSupplier;
        this.stateSupplier = builder.stateSupplier;
        this.variables = builder.variables;
        this.consoleCommand = null;
        this.function = builder.function;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ConsoleCommand getConsoleCommand() {
        return this.consoleCommand;
    }

    public String getDescription() {
        return this.consoleCommand != null ? this.consoleCommand.getDescription() : this.description;
    }

    public char getKey() {
        return this.key;
    }

    public Optional<String> getSystemMessage() {
        return this.systemMessage;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public Supplier<String> getColorSupplier() {
        return this.consoleCommand != null ? this.consoleCommand.getHelpState().getColorSupplier() : this.colorSupplier;
    }

    public Supplier<String> getStateSupplier() {
        return this.consoleCommand != null ? this.consoleCommand.getHelpState().getStateSupplier() : this.stateSupplier;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public Optional<Function<Assistant, CompletionStage<?>>> getFunction() {
        return this.function;
    }

    public static class Builder {
        private String description;
        private char key = '\u0000';
        private Optional<String> systemMessage = Optional.empty();
        private String userMessage;
        private Supplier<String> colorSupplier = new Supplier<String>(){

            @Override
            public String get() {
                return "\u001b[39m";
            }
        };
        private Supplier<String> stateSupplier = null;
        private Map<String, String> variables = Map.of();
        private Optional<Function<Assistant, CompletionStage<?>>> function = Optional.empty();

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder key(char key) {
            this.key = key;
            return this;
        }

        public Builder systemMessage(String systemMessage) {
            this.systemMessage = Optional.of(systemMessage);
            return this;
        }

        public Builder userMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public Builder colorSupplier(Supplier<String> colorSupplier) {
            this.colorSupplier = colorSupplier;
            return this;
        }

        public Builder stateSupplier(Supplier<String> stateSupplier) {
            this.stateSupplier = stateSupplier;
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.variables = variables;
            return this;
        }

        public Builder function(Function<Assistant, CompletionStage<?>> function) {
            this.function = Optional.of(function);
            return this;
        }

        public AssistantConsoleBuildItem build() {
            if (this.key == '\u0000') {
                throw new IllegalStateException("You have to specify a key. This is the key the user will press to get to your function");
            }
            if (this.description == null || this.description.isBlank()) {
                throw new IllegalStateException("You have to specify a description. This is what the user will see in the console menu");
            }
            if (this.userMessage == null && !this.function.isPresent()) {
                throw new IllegalStateException("You have to specify userMessage that will be send to AI, or implement your own using the function");
            }
            return new AssistantConsoleBuildItem(this);
        }
    }
}

