/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.io.Serializable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.internal.PrimitiveKind;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.internal.jdk.JdkMethodDetails;
import org.hibernate.models.internal.jdk.JdkTrackingTypeSwitcher;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;

public class JdkBuilders
implements ClassDetailsBuilder,
Serializable {
    public static final JdkBuilders DEFAULT_BUILDER = new JdkBuilders();

    @Override
    public JdkClassDetails buildClassDetails(String name, ModelsContext modelsContext) {
        return JdkBuilders.buildClassDetailsStatic(name, modelsContext);
    }

    public static JdkClassDetails buildClassDetailsStatic(String name, ModelsContext modelsContext) {
        if (Character.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Character.TYPE, modelsContext);
        }
        if (Byte.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Byte.TYPE, modelsContext);
        }
        if (Boolean.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Boolean.TYPE, modelsContext);
        }
        if (Short.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Short.TYPE, modelsContext);
        }
        if (Integer.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Integer.TYPE, modelsContext);
        }
        if (Long.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Long.TYPE, modelsContext);
        }
        if (Float.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Float.TYPE, modelsContext);
        }
        if (Double.TYPE.getName().equals(name)) {
            return JdkBuilders.buildClassDetailsStatic(Double.TYPE, modelsContext);
        }
        if (name.startsWith("[")) {
            return JdkBuilders.buildArrayClassDetails(name, modelsContext);
        }
        try {
            Class loadedClass = modelsContext.getClassLoading().classForName(name);
            return JdkBuilders.buildClassDetailsStatic(loadedClass, modelsContext);
        }
        catch (UnknownClassException e) {
            try {
                Class packageInfoClass = modelsContext.getClassLoading().classForName(name + ".package-info");
                return JdkBuilders.buildClassDetailsStatic(packageInfoClass, modelsContext);
            }
            catch (UnknownClassException noPackage) {
                throw e;
            }
        }
    }

    private static JdkClassDetails buildArrayClassDetails(String name, ModelsContext modelsContext) {
        assert (name.startsWith("["));
        int dimensionCount = StringHelper.countArrayDimensions(name);
        assert (dimensionCount > 0);
        String componentTypeName = name.substring(1);
        ClassDetails componentTypeDetails = JdkBuilders.resolveArrayComponentType(componentTypeName, modelsContext);
        Class javaClass = componentTypeDetails.toJavaClass();
        TypeDescriptor.OfField arrayType = javaClass.arrayType();
        return new JdkClassDetails((Class<?>)arrayType, modelsContext);
    }

    private static ClassDetails resolveArrayComponentType(String componentTypeName, ModelsContext modelsContext) {
        if (componentTypeName.startsWith("[")) {
            return JdkBuilders.buildArrayClassDetails(componentTypeName, modelsContext);
        }
        ClassDetailsRegistry classDetailsRegistry = modelsContext.getClassDetailsRegistry();
        if (componentTypeName.length() == 1) {
            PrimitiveKind primitiveKind = PrimitiveKind.resolveFromTypeChar(componentTypeName.charAt(0));
            return classDetailsRegistry.resolveClassDetails(primitiveKind.getTypeName());
        }
        if (!componentTypeName.startsWith("L")) {
            throw new AssertionError((Object)("Unexpected array component type prefix - " + componentTypeName));
        }
        if (!componentTypeName.endsWith(";")) {
            throw new AssertionError((Object)("Unexpected array component type format : no semi-colon - " + componentTypeName));
        }
        String objectComponentTypeName = componentTypeName.substring(1, componentTypeName.length() - 1);
        return classDetailsRegistry.resolveClassDetails(objectComponentTypeName.replace('/', '.'));
    }

    public static JdkClassDetails buildClassDetailsStatic(Class<?> javaClass, ModelsContext modelsContext) {
        return new JdkClassDetails(javaClass, modelsContext);
    }

    public static JdkMethodDetails buildMethodDetails(Method method, ClassDetails declaringType, ModelsContext modelsContext) {
        Class<?> returnType;
        if (method.getParameterCount() == 0 && !JdkBuilders.isVoid(returnType = method.getReturnType()) && !ModifierUtils.isStatic(method.getModifiers())) {
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return JdkBuilders.buildGetterDetails(method, declaringType, modelsContext);
            }
            if (JdkBuilders.isBoolean(returnType) && methodName.startsWith("is")) {
                return JdkBuilders.buildGetterDetails(method, declaringType, modelsContext);
            }
        }
        if (method.getParameterCount() == 1 && JdkBuilders.isVoid(method.getReturnType()) && !ModifierUtils.isStatic(method.getModifiers()) && method.getName().startsWith("set")) {
            return JdkBuilders.buildSetterDetails(method, declaringType, modelsContext);
        }
        return new JdkMethodDetails(method, MethodDetails.MethodKind.OTHER, null, declaringType, modelsContext);
    }

    public static JdkMethodDetails buildGetterDetails(Method method, ClassDetails declaringType, ModelsContext modelsContext) {
        return new JdkMethodDetails(method, MethodDetails.MethodKind.GETTER, JdkBuilders.toTypeDetails(method.getGenericReturnType(), modelsContext), declaringType, modelsContext);
    }

    private static TypeDetails toTypeDetails(Type genericType, ModelsContext modelsContext) {
        return new JdkTrackingTypeSwitcher(modelsContext).switchType(genericType);
    }

    public static JdkMethodDetails buildSetterDetails(Method method, ClassDetails declaringType, ModelsContext modelsContext) {
        return new JdkMethodDetails(method, MethodDetails.MethodKind.SETTER, JdkBuilders.toTypeDetails(method.getGenericParameterTypes()[0], modelsContext), declaringType, modelsContext);
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static boolean isVoid(Class<?> type) {
        return type == Void.TYPE || type == Void.class;
    }
}

