/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.events.impl;

import java.time.Instant;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;

@Immutable
public class BaseEventLog
implements EventLog {
    protected final Instant when;
    protected final EventLogLevel level;
    protected final EventLogCategory category;
    protected final String message;
    protected final String detail;
    protected final String who;
    protected final String context;
    protected final String scope;

    public BaseEventLog(Instant when, EventLogLevel level, EventLogCategory category, String message, String detail, String context, String who, String scope) {
        this.when = when;
        this.level = level;
        this.category = category;
        this.message = message;
        this.detail = detail;
        this.who = who;
        this.context = context;
        this.scope = scope;
    }

    public BaseEventLog(Instant when, EventLogLevel level, EventLogCategory category, String message) {
        this(when, level, category, message, null, null, null, null);
    }

    @Override
    public Instant getWhen() {
        return this.when;
    }

    @Override
    public EventLogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public EventLogCategory getCategory() {
        return this.category;
    }

    @Override
    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    @Override
    public Optional<String> getWho() {
        return Optional.ofNullable(this.who);
    }

    @Override
    public Optional<String> getContext() {
        return Optional.ofNullable(this.context);
    }

    @Override
    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    public int compareTo(EventLog that) {
        return that.getWhen().compareTo(this.when);
    }

    public String toString() {
        return "BaseEventLog{when=" + String.valueOf(this.when) + ", level=" + String.valueOf((Object)this.level) + ", category=" + String.valueOf((Object)this.category) + ", message='" + this.message + "', detail='" + this.detail + "', who='" + this.who + "', context='" + this.context + "', scope='" + this.scope + "'}";
    }
}

