/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.LocaleUtils;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RequestDumpingHandler
implements HttpHandler {
    private final HttpHandler next;

    public RequestDumpingHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map<String, Cookie> cookies;
        final StringBuilder sb = new StringBuilder();
        final SecurityContext sc = exchange.getSecurityContext();
        sb.append("\n----------------------------REQUEST---------------------------\n");
        sb.append("               URI=" + exchange.getRequestURI() + "\n");
        sb.append(" characterEncoding=" + exchange.getRequestHeader("Content-Encoding") + "\n");
        sb.append("     contentLength=" + exchange.getRequestContentLength() + "\n");
        sb.append("       contentType=" + exchange.getRequestHeader("Content-Type") + "\n");
        if (sc != null) {
            if (sc.isAuthenticated()) {
                sb.append("          authType=" + sc.getMechanismName() + "\n");
                sb.append("         principle=" + String.valueOf(sc.getAuthenticatedAccount().getPrincipal()) + "\n");
            } else {
                sb.append("          authType=none\n");
            }
        }
        if ((cookies = exchange.getRequestCookies()) != null) {
            for (Map.Entry entry : cookies.entrySet()) {
                Cookie cookie = (Cookie)entry.getValue();
                sb.append("            cookie=" + cookie.getName() + "=" + cookie.getValue() + "\n");
            }
        }
        for (String string : exchange.getRequestHeaderNames()) {
            for (String value : exchange.getRequestHeaders(string)) {
                sb.append("            header=" + string + "=" + value + "\n");
            }
        }
        sb.append("            locale=" + String.valueOf(LocaleUtils.getLocalesFromHeader(exchange.getRequestHeader("Accept-Language"))) + "\n");
        sb.append("            method=" + exchange.getRequestMethod() + "\n");
        Map<String, Deque<String>> pnames = exchange.getQueryParameters();
        for (Map.Entry<String, Deque<String>> entry : pnames.entrySet()) {
            String pname = entry.getKey();
            Iterator<String> pvalues = entry.getValue().iterator();
            sb.append("         parameter=");
            sb.append(pname);
            sb.append('=');
            while (pvalues.hasNext()) {
                sb.append(pvalues.next());
                if (!pvalues.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("\n");
        }
        sb.append("          getProtocol=" + exchange.getProtocol() + "\n");
        sb.append("       queryString=" + exchange.getQueryString() + "\n");
        sb.append("        remoteAddr=" + String.valueOf(exchange.getSourceAddress()) + "\n");
        sb.append("        remoteHost=" + exchange.getSourceAddress().getHostName() + "\n");
        sb.append("            scheme=" + exchange.getRequestScheme() + "\n");
        sb.append("              host=" + exchange.getRequestHeader("Host") + "\n");
        sb.append("        serverPort=" + exchange.getDestinationAddress().getPort() + "\n");
        sb.append("          isSecure=" + exchange.isSecure() + "\n");
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange) {
                RequestDumpingHandler.this.dumpRequestBody(exchange, sb);
                sb.append("--------------------------RESPONSE--------------------------\n");
                if (sc != null) {
                    if (sc.isAuthenticated()) {
                        sb.append("          authType=" + sc.getMechanismName() + "\n");
                        sb.append("         principle=" + String.valueOf(sc.getAuthenticatedAccount().getPrincipal()) + "\n");
                    } else {
                        sb.append("          authType=none\n");
                    }
                }
                sb.append("     contentLength=" + exchange.getResponseContentLength() + "\n");
                sb.append("       contentType=" + exchange.getResponseHeader("Content-Type") + "\n");
                Map<String, Cookie> cookies = exchange.getResponseCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies.values()) {
                        sb.append("            cookie=" + cookie.getName() + "=" + cookie.getValue() + "; domain=" + cookie.getDomain() + "; path=" + cookie.getPath() + "\n");
                    }
                }
                for (String header : exchange.getResponseHeaderNames()) {
                    for (String value : exchange.getResponseHeaders(header)) {
                        sb.append("            header=" + header + "=" + value + "\n");
                    }
                }
                sb.append("            status=" + exchange.getStatusCode() + "\n");
                sb.append("\n==============================================================");
                UndertowLogger.REQUEST_DUMPER_LOGGER.info(sb.toString());
            }
        });
        this.next.handleRequest(exchange);
    }

    private void dumpRequestBody(HttpServerExchange exchange, StringBuilder sb) {
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new RequestDumpingHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "dump-request";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

