/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.RoutingUtils;
import io.quarkus.vertx.http.runtime.StaticResourcesConfig;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

@Recorder
public class StaticResourcesRecorder {
    public static final String META_INF_RESOURCES = "META-INF/resources";
    private static volatile List<Path> hotDeploymentResourcePaths;
    private final VertxHttpBuildTimeConfig httpBuildTimeConfig;
    private final RuntimeValue<VertxHttpConfig> httpConfig;

    public StaticResourcesRecorder(VertxHttpBuildTimeConfig httpBuildTimeConfig, RuntimeValue<VertxHttpConfig> httpConfig) {
        this.httpBuildTimeConfig = httpBuildTimeConfig;
        this.httpConfig = httpConfig;
    }

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public Consumer<Route> start(final Set<String> knownPaths) {
        final ArrayList<Object> handlers = new ArrayList<Object>();
        final Set compressMediaTypes = this.httpBuildTimeConfig.enableCompression() && this.httpBuildTimeConfig.compressMediaTypes().isPresent() ? Set.copyOf((Collection)this.httpBuildTimeConfig.compressMediaTypes().get()) : Set.of();
        StaticResourcesConfig config = ((VertxHttpConfig)this.httpConfig.getValue()).staticResources();
        if (hotDeploymentResourcePaths != null && !hotDeploymentResourcePaths.isEmpty()) {
            for (Path resourcePath : hotDeploymentResourcePaths) {
                String root = resourcePath.toAbsolutePath().toString();
                final StaticHandler staticHandler = StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)root).setDefaultContentEncoding(config.contentEncoding().name()).setCachingEnabled(false).setIndexPage(config.indexPage()).setIncludeHidden(config.includeHidden()).setEnableRangeSupport(config.enableRangeSupport());
                handlers.add(new Handler<RoutingContext>(){

                    public void handle(RoutingContext ctx) {
                        try {
                            String path = RoutingUtils.getNormalizedAndDecodedPath(ctx);
                            if (path == null) {
                                ctx.fail(HttpResponseStatus.BAD_REQUEST.code());
                                return;
                            }
                            RoutingUtils.compressIfNeeded(StaticResourcesRecorder.this.httpBuildTimeConfig, compressMediaTypes, ctx, path);
                            staticHandler.handle((Object)ctx);
                        }
                        catch (Exception e) {
                            ctx.next();
                        }
                    }
                });
            }
        }
        if (!knownPaths.isEmpty()) {
            final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            final StaticHandler staticHandler = StaticHandler.create((String)META_INF_RESOURCES).setDefaultContentEncoding("UTF-8").setCachingEnabled(config.cachingEnabled()).setIndexPage(config.indexPage()).setIncludeHidden(config.includeHidden()).setEnableRangeSupport(config.enableRangeSupport()).setMaxCacheSize(config.maxCacheSize()).setCacheEntryTimeout(config.cacheEntryTimeout().toMillis()).setMaxAgeSeconds(config.maxAge().toSeconds());
            final String indexPage = config.indexPage().charAt(0) == '/' ? config.indexPage().substring(1) : config.indexPage();
            handlers.add(new Handler<RoutingContext>(){

                public void handle(RoutingContext ctx) {
                    String rel = RoutingUtils.resolvePath(ctx);
                    if (rel == null) {
                        ctx.fail(HttpResponseStatus.BAD_REQUEST.code());
                        return;
                    }
                    if (knownPaths.contains(rel) || rel.endsWith("/") && knownPaths.contains(rel.concat(indexPage))) {
                        RoutingUtils.compressIfNeeded(StaticResourcesRecorder.this.httpBuildTimeConfig, compressMediaTypes, ctx, rel);
                        staticHandler.handle((Object)ctx);
                    } else {
                        Thread.currentThread().setContextClassLoader(currentCl);
                        ctx.next();
                    }
                }
            });
        }
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.method(HttpMethod.GET);
                route.method(HttpMethod.HEAD);
                route.method(HttpMethod.OPTIONS);
                for (Handler i : handlers) {
                    route.handler(i);
                }
            }
        };
    }
}

