/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.CertificateRoleAttribute;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityConfiguration;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.quarkus.vertx.http.runtime.security.RolesMapping;
import io.quarkus.vertx.http.security.MTLS;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class HttpSecurityRecorder {
    private static final Logger log = Logger.getLogger(HttpSecurityRecorder.class);
    private final RuntimeValue<VertxHttpConfig> httpConfig;
    private final VertxHttpBuildTimeConfig httpBuildTimeConfig;

    public HttpSecurityRecorder(RuntimeValue<VertxHttpConfig> httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig) {
        this.httpConfig = httpConfig;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
    }

    public RuntimeValue<AuthenticationHandler> authenticationMechanismHandler(boolean proactiveAuthentication, boolean propagateRoutingContext) {
        return new RuntimeValue((Object)new AuthenticationHandler(proactiveAuthentication, propagateRoutingContext));
    }

    public Handler<RoutingContext> getHttpAuthenticatorHandler(RuntimeValue<AuthenticationHandler> handlerRuntimeValue) {
        return (Handler)handlerRuntimeValue.getValue();
    }

    public void initializeHttpAuthenticatorHandler(RuntimeValue<AuthenticationHandler> handlerRuntimeValue, BeanContainer beanContainer) {
        ((AuthenticationHandler)handlerRuntimeValue.getValue()).init((AbstractPathMatchingHttpSecurityPolicy)beanContainer.beanInstance(PathMatchingHttpSecurityPolicy.class, new Annotation[0]), HttpSecurityConfiguration.get().rolesMapping());
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (HttpAuthorizer)CDI.current().select(HttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public void formAuthPostHandler(RuntimeValue<Router> httpRouter) {
        HttpSecurityConfiguration config = HttpSecurityConfiguration.get();
        if (config.formAuthEnabled()) {
            ((Router)httpRouter.getValue()).post(config.formPostLocation()).order(-150).handler((Handler)new Handler<RoutingContext>(){

                public void handle(final RoutingContext event) {
                    Uni user = (Uni)event.get("io.quarkus.vertx.http.deferred-identity");
                    user.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                        public void onSubscribe(UniSubscription uniSubscription) {
                        }

                        public void onItem(SecurityIdentity securityIdentity) {
                            if (!event.response().ended()) {
                                event.response().end();
                            }
                        }

                        public void onFailure(Throwable throwable) {
                            if (!event.response().ended() && !event.failed()) {
                                event.fail(throwable);
                            }
                        }
                    });
                }
            });
        }
    }

    public Supplier<EagerSecurityInterceptorStorage> createSecurityInterceptorStorage(Map<RuntimeValue<MethodDescription>, Consumer<RoutingContext>> endpointRuntimeValToInterceptor, final Map<String, Consumer<RoutingContext>> classNameToInterceptor) {
        final HashMap<MethodDescription, Consumer<RoutingContext>> endpointToInterceptor = new HashMap<MethodDescription, Consumer<RoutingContext>>();
        for (Map.Entry<RuntimeValue<MethodDescription>, Consumer<RoutingContext>> entry : endpointRuntimeValToInterceptor.entrySet()) {
            endpointToInterceptor.put((MethodDescription)entry.getKey().getValue(), entry.getValue());
        }
        return new Supplier<EagerSecurityInterceptorStorage>(){

            @Override
            public EagerSecurityInterceptorStorage get() {
                return new EagerSecurityInterceptorStorage(endpointToInterceptor, classNameToInterceptor);
            }
        };
    }

    public Supplier<Map<String, Object>> createAdditionalSecEventPropsSupplier() {
        return new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> get() {
                RoutingContext event;
                if (Arc.container().requestContext().isActive() && (event = ((CurrentVertxRequest)Arc.container().instance(CurrentVertxRequest.class, new Annotation[0]).get()).getCurrent()) != null) {
                    User user = event.user();
                    if (user instanceof QuarkusHttpUser) {
                        QuarkusHttpUser user2 = (QuarkusHttpUser)user;
                        return Map.of(RoutingContext.class.getName(), event, SecurityIdentity.class.getName(), user2.getSecurityIdentity());
                    }
                    return Map.of(RoutingContext.class.getName(), event);
                }
                return Map.of();
            }
        };
    }

    public void prepareHttpSecurityConfiguration(ShutdownContext shutdownContext) {
        HttpSecurityConfiguration.get((VertxHttpConfig)this.httpConfig.getValue(), this.httpBuildTimeConfig);
        shutdownContext.addShutdownTask(HttpSecurityConfiguration::clear);
    }

    public Supplier<FormAuthenticationMechanism> createFormAuthMechanism() {
        return new Supplier<FormAuthenticationMechanism>(){

            @Override
            public FormAuthenticationMechanism get() {
                return HttpSecurityConfiguration.get().getFormAuthenticationMechanism();
            }
        };
    }

    public void setMtlsCertificateRoleProperties() {
        VertxHttpConfig httpConfig;
        MtlsAuthenticationMechanism mTLS = HttpSecurityConfiguration.get().getMtlsAuthenticationMechanism();
        if (mTLS != null && (httpConfig = (VertxHttpConfig)this.httpConfig.getValue()).auth().certificateRoleProperties().isPresent()) {
            if (mTLS.isCertificateToRolesMapperSet()) {
                throw new ConfigurationException("The 'quarkus.http.auth.certificate-role-properties' configuration property is set, but the certificate to roles mapping has been configured " + "programmatically with the '%s' API".formatted(MTLS.class.getName()), Set.of("quarkus.http.auth.certificate-role-properties"));
            }
            Path rolesPath = httpConfig.auth().certificateRoleProperties().get();
            URL rolesResource = null;
            if (Files.exists(rolesPath, new LinkOption[0])) {
                try {
                    rolesResource = rolesPath.toUri().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                rolesResource = Thread.currentThread().getContextClassLoader().getResource(rolesPath.toString());
            }
            if (rolesResource == null) {
                throw new ConfigurationException("quarkus.http.auth.certificate-role-properties location can not be resolved", Set.of("quarkus.http.auth.certificate-role-properties"));
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(rolesResource.openStream(), StandardCharsets.UTF_8));){
                Properties rolesProps = new Properties();
                rolesProps.load(reader);
                HashMap<String, Set<String>> roles = new HashMap<String, Set<String>>();
                for (Map.Entry<Object, Object> e : rolesProps.entrySet()) {
                    log.debugf("Added role mapping for %s:%s", e.getKey(), e.getValue());
                    roles.put((String)e.getKey(), HttpSecurityRecorder.parseRoles((String)e.getValue()));
                }
                if (!roles.isEmpty()) {
                    CertificateRoleAttribute certRolesAttribute = new CertificateRoleAttribute(httpConfig.auth().certificateRoleAttribute(), roles);
                    mTLS.setCertificateToRolesMapper(certRolesAttribute.rolesMapper());
                }
            }
            catch (Exception e) {
                log.warnf("Unable to read roles mappings from %s:%s", (Object)rolesPath, (Object)e.getMessage());
            }
        }
    }

    public RuntimeValue<MethodDescription> createMethodDescription(String className, String methodName, String[] paramTypes) {
        return new RuntimeValue((Object)new MethodDescription(className, methodName, paramTypes));
    }

    public Function<String, Consumer<RoutingContext>> authMechanismSelectionInterceptorCreator() {
        return new Function<String, Consumer<RoutingContext>>(){

            @Override
            public Consumer<RoutingContext> apply(final String authMechanismName) {
                return new Consumer<RoutingContext>(){

                    @Override
                    public void accept(RoutingContext routingContext) {
                        HttpAuthenticator.selectAuthMechanism(routingContext, authMechanismName);
                    }
                };
            }
        };
    }

    public RuntimeValue<List<String>> getSecurityIdentityContextKeySupplier() {
        return new RuntimeValue(List.of("quarkus.http.routing.context"));
    }

    public Consumer<RoutingContext> createEagerSecurityInterceptor(Function<String, Consumer<RoutingContext>> interceptorCreator, String annotationValue) {
        return interceptorCreator.apply(annotationValue);
    }

    public Consumer<RoutingContext> compoundSecurityInterceptor(final Consumer<RoutingContext> interceptor1, final Consumer<RoutingContext> interceptor2) {
        return new Consumer<RoutingContext>(){

            @Override
            public void accept(RoutingContext routingContext) {
                interceptor1.accept(routingContext);
                interceptor2.accept(routingContext);
            }
        };
    }

    public void selectAuthMechanismViaAnnotation() {
        HttpAuthenticator.selectAuthMechanismWithAnnotation();
    }

    private static Set<String> parseRoles(String value) {
        HashSet<String> roles = new HashSet<String>();
        for (String s : value.split(",")) {
            roles.add(s.trim());
        }
        return Set.copyOf(roles);
    }

    public Supplier<BasicAuthenticationMechanism> basicAuthenticationMechanismBean() {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return HttpSecurityConfiguration.get().getBasicAuthenticationMechanism();
            }
        };
    }

    public static final class AuthenticationHandler
    implements Handler<RoutingContext> {
        volatile HttpAuthenticator authenticator;
        private final boolean proactiveAuthentication;
        private final boolean propagateRoutingContext;
        private AbstractPathMatchingHttpSecurityPolicy pathMatchingPolicy;
        private RolesMapping rolesMapping;

        AuthenticationHandler(boolean proactiveAuthentication, boolean propagateRoutingContext) {
            this.proactiveAuthentication = proactiveAuthentication;
            this.propagateRoutingContext = propagateRoutingContext;
        }

        public AuthenticationHandler(boolean proactiveAuthentication) {
            this(proactiveAuthentication, false);
        }

        public void handle(final RoutingContext event) {
            Context context;
            if (this.authenticator == null) {
                this.authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
            }
            if (this.propagateRoutingContext && (context = Vertx.currentContext()) != null && VertxContext.isDuplicatedContext((Context)context)) {
                context.putLocal((Object)"quarkus.http.routing.context", (Object)event);
            }
            event.put(HttpAuthenticator.class.getName(), (Object)this.authenticator);
            if (this.pathMatchingPolicy != null) {
                event.put(AbstractPathMatchingHttpSecurityPolicy.class.getName(), (Object)this.pathMatchingPolicy);
            }
            if (this.rolesMapping != null) {
                event.put("io.quarkus.vertx.http.runtime.security.RolesMapping", (Object)this.rolesMapping);
            }
            if (this.proactiveAuthentication) {
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new DefaultAuthFailureHandler(){

                    @Override
                    protected void proceed(Throwable throwable) {
                        if (!event.failed()) {
                            event.fail(throwable);
                        }
                    }
                });
            } else {
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new DefaultAuthFailureHandler(){

                    @Override
                    protected void proceed(Throwable throwable) {
                        if (throwable instanceof AuthenticationCompletionException && throwable.getMessage() != null && LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                            event.end(throwable.getMessage());
                        } else {
                            event.end();
                        }
                    }
                });
            }
            if (this.proactiveAuthentication) {
                final Uni potentialUser = this.authenticator.attemptAuthentication(event).memoize().indefinitely();
                potentialUser.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                    public void onSubscribe(UniSubscription subscription) {
                    }

                    public void onItem(SecurityIdentity identity) {
                        if (event.response().ended()) {
                            return;
                        }
                        if (identity == null) {
                            final Uni anon = authenticator.getIdentityProviderManager().authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new AnonymousAuthenticationRequest(), event));
                            anon.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                                public void onSubscribe(UniSubscription subscription) {
                                }

                                public void onItem(SecurityIdentity item) {
                                    event.put("io.quarkus.vertx.http.deferred-identity", (Object)anon);
                                    event.setUser((User)new QuarkusHttpUser(item));
                                    event.next();
                                }

                                public void onFailure(Throwable failure) {
                                    BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                                    if (handler != null) {
                                        handler.accept(event, failure);
                                    }
                                }
                            });
                        } else {
                            event.setUser((User)new QuarkusHttpUser(identity));
                            event.put("io.quarkus.vertx.http.deferred-identity", (Object)potentialUser);
                            event.next();
                        }
                    }

                    public void onFailure(Throwable failure) {
                        BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                        if (handler != null) {
                            handler.accept(event, failure);
                        }
                    }
                });
            } else {
                Uni lazyUser = Uni.createFrom().nullItem().flatMap(n -> this.authenticator.attemptAuthentication(event)).memoize().indefinitely().flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                        if (securityIdentity == null) {
                            return authenticator.getIdentityProviderManager().authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new AnonymousAuthenticationRequest(), event));
                        }
                        return Uni.createFrom().item((Object)securityIdentity);
                    }
                }).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<SecurityIdentity, Throwable, Boolean>(){

                    public void accept(SecurityIdentity identity, Throwable throwable, Boolean aBoolean) {
                        BiConsumer handler;
                        if (identity != null) {
                            event.setUser((User)new QuarkusHttpUser(identity));
                        } else if (throwable != null && (handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler")) != null) {
                            handler.accept(event, throwable);
                        }
                    }
                }).memoize().indefinitely();
                event.put("io.quarkus.vertx.http.deferred-identity", (Object)lazyUser);
                event.next();
            }
        }

        public void init(AbstractPathMatchingHttpSecurityPolicy pathMatchingPolicy, RolesMapping rolesMapping) {
            if (this.pathMatchingPolicy == null) {
                this.pathMatchingPolicy = pathMatchingPolicy;
            }
            if (this.rolesMapping == null) {
                this.rolesMapping = rolesMapping;
            }
        }
    }

    public static abstract class DefaultAuthFailureHandler
    implements BiConsumer<RoutingContext, Throwable> {
        private static final String OTHER_AUTHENTICATION_FAILURE = "io.quarkus.vertx.http.runtime.security.other-auth-failure";
        static final String DEV_MODE_AUTHENTICATION_FAILURE_BODY = "io.quarkus.vertx.http.runtime.security.dev-mode.auth-failure-body";

        protected DefaultAuthFailureHandler() {
        }

        @Override
        public void accept(final RoutingContext event, Throwable throwable) {
            if (event.response().ended()) {
                return;
            }
            throwable = DefaultAuthFailureHandler.extractRootCause(throwable);
            if (LaunchMode.current().isDev() && throwable instanceof AuthenticationException && throwable.getMessage() != null) {
                event.put(DEV_MODE_AUTHENTICATION_FAILURE_BODY, (Object)throwable.getMessage());
            }
            if (throwable instanceof AuthenticationFailedException) {
                final AuthenticationFailedException authenticationFailedException = (AuthenticationFailedException)throwable;
                HttpSecurityUtils.addAuthenticationFailureToEvent(authenticationFailedException, event);
                DefaultAuthFailureHandler.getAuthenticator(event).sendChallenge(event).subscribe().with((Consumer)new Consumer<Boolean>(){

                    @Override
                    public void accept(Boolean aBoolean) {
                        if (!event.response().ended()) {
                            this.proceed((Throwable)authenticationFailedException);
                        }
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    @Override
                    public void accept(Throwable throwable) {
                        event.fail(throwable);
                    }
                });
            } else if (throwable instanceof AuthenticationCompletionException) {
                log.debug((Object)"Authentication has failed, returning HTTP status 401");
                event.response().setStatusCode(401);
                this.proceed(throwable);
            } else if (throwable instanceof AuthenticationRedirectException) {
                final AuthenticationRedirectException redirectEx = (AuthenticationRedirectException)throwable;
                event.response().setStatusCode(redirectEx.getCode());
                event.response().headers().set(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
                event.response().headers().set("Pragma", "no-cache");
                if (redirectEx.getCode() == 200) {
                    log.debugf("Form post redirect to %s", (Object)redirectEx.getRedirectUri());
                    event.response().putHeader("Content-Type", "text/html; charset=UTF-8");
                    event.response().write(redirectEx.getRedirectUri()).onComplete((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> v) {
                            this.proceed((Throwable)redirectEx);
                        }
                    });
                } else {
                    log.debugf("Redirect to %s ", (Object)redirectEx.getRedirectUri());
                    event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)redirectEx.getRedirectUri());
                    this.proceed(throwable);
                }
            } else {
                event.put(OTHER_AUTHENTICATION_FAILURE, (Object)Boolean.TRUE);
                event.fail(throwable);
            }
        }

        protected abstract void proceed(Throwable var1);

        private static HttpAuthenticator getAuthenticator(RoutingContext event) {
            return (HttpAuthenticator)event.get(HttpAuthenticator.class.getName());
        }

        public static Throwable extractRootCause(Throwable throwable) {
            while (throwable instanceof CompletionException && throwable.getCause() != null || throwable instanceof CompositeException) {
                if (throwable instanceof CompositeException) {
                    throwable = (Throwable)((CompositeException)throwable).getCauses().get(0);
                    continue;
                }
                throwable = throwable.getCause();
            }
            return throwable;
        }

        public static void markIfOtherAuthenticationFailure(RoutingContext event, Throwable throwable) {
            if (!(throwable instanceof AuthenticationException)) {
                event.put(OTHER_AUTHENTICATION_FAILURE, (Object)Boolean.TRUE);
            }
        }

        public static void removeMarkAsOtherAuthenticationFailure(RoutingContext event) {
            event.remove(OTHER_AUTHENTICATION_FAILURE);
        }

        public static boolean isOtherAuthenticationFailure(RoutingContext event) {
            return Boolean.TRUE.equals(event.get(OTHER_AUTHENTICATION_FAILURE));
        }
    }
}

