/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.compatibility;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.compatibility.CompatibilityMetadataProvider;

public abstract class AbstractCompatibilityMetadataProvider
implements CompatibilityMetadataProvider {
    final String spi;
    final Config.Scope config;

    public AbstractCompatibilityMetadataProvider(String spi, String providerId) {
        this.spi = spi;
        this.config = Config.scope((String[])new String[]{spi, providerId});
    }

    protected abstract boolean isEnabled(Config.Scope var1);

    public Map<String, String> metadata() {
        if (!this.isEnabled(this.config)) {
            return Map.of();
        }
        HashMap<String, String> metadata = new HashMap<String, String>(this.customMeta());
        this.configKeys().forEach(key -> {
            String value = this.config.get(key);
            if (value != null) {
                metadata.put((String)key, value);
            }
        });
        return metadata;
    }

    public String getId() {
        return this.spi;
    }

    protected Map<String, String> customMeta() {
        return Map.of();
    }

    protected Stream<String> configKeys() {
        return Stream.of(new String[0]);
    }
}

