/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.GroupModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@ProtoTypeId(value=65582)
public class GroupRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    @ProtoField(value=2)
    final String realmId;
    @ProtoField(value=3)
    final String parentId;

    public GroupRemovedEvent(String groupId, String realmId, String parentId) {
        super(groupId);
        this.realmId = Objects.requireNonNull(realmId);
        this.parentId = parentId;
    }

    @ProtoFactory
    static GroupRemovedEvent protoFactory(String id, String realmId, String parentId) {
        return new GroupRemovedEvent(id, realmId, parentId);
    }

    public static GroupRemovedEvent create(GroupModel group, String realmId) {
        return new GroupRemovedEvent(group.getId(), realmId, group.getParentId());
    }

    public String toString() {
        return String.format("GroupRemovedEvent [ realmId=%s, groupId=%s, parentId=%s ]", this.realmId, this.getId(), this.parentId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        realmCache.groupNameInvalidations(this.getId(), invalidations);
        if (this.parentId != null) {
            invalidations.add(this.parentId);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupRemovedEvent that = (GroupRemovedEvent)o;
        return this.realmId.equals(that.realmId) && Objects.equals(this.parentId, that.parentId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.realmId.hashCode();
        result = 31 * result + Objects.hashCode(this.parentId);
        return result;
    }
}

