/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;

public class InfinispanKeycloakTransaction
implements NonBlockingTransaction {
    private static final Logger log = Logger.getLogger(InfinispanKeycloakTransaction.class);
    private static final CacheTask TOMBSTONE = new CacheTask(){

        @Override
        public void execute(AggregateCompletionStage<Void> stage) {
        }

        public String toString() {
            return "Tombstone after removal";
        }
    };
    private final Map<Object, CacheTask> tasks = new HashMap<Object, CacheTask>();

    @Override
    public void asyncCommit(AggregateCompletionStage<Void> stage, Consumer<DatabaseUpdate> databaseUpdates) {
        for (CacheTask task : this.tasks.values()) {
            task.execute(stage);
        }
    }

    @Override
    public void asyncRollback(AggregateCompletionStage<Void> stage) {
        this.tasks.clear();
    }

    public <K, V> void put(final BasicCache<K, V> cache, final K key, V value, long lifespan, TimeUnit lifespanUnit) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD_WITH_LIFESPAN, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalStateException("Can't add session: task in progress for session");
        }
        this.tasks.put(taskKey, new CacheTaskWithValue<V>(value, lifespan, lifespanUnit){

            @Override
            public void execute(AggregateCompletionStage<Void> stage) {
                stage.dependsOn((CompletionStage)InfinispanKeycloakTransaction.decorateCache(cache).putAsync(key, this.value, this.lifespan, this.lifespanUnit));
            }

            public String toString() {
                return String.format("CacheTaskWithValue: Operation 'put' for key %s, lifespan %d TimeUnit %s", new Object[]{key, this.lifespan, this.lifespanUnit});
            }

            @Override
            public Operation getOperation() {
                return Operation.PUT;
            }
        });
    }

    public <K, V> void replace(final Cache<K, V> cache, final K key, V value, long lifespan, TimeUnit lifespanUnit) {
        log.tracev("Adding cache operation: {0} on {1}. Lifespan {2} {3}.", new Object[]{CacheOperation.REPLACE, key, lifespan, lifespanUnit});
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null) {
            if (current instanceof CacheTaskWithValue) {
                ((CacheTaskWithValue)current).setValue(value);
                ((CacheTaskWithValue)current).updateLifespan(lifespan, lifespanUnit);
            } else if (current != TOMBSTONE && current.getOperation() != Operation.REMOVE) {
                throw new IllegalStateException("Can't replace entry: task " + String.valueOf(current) + " in progress for session");
            }
        } else {
            this.tasks.put(taskKey, new CacheTaskWithValue<V>(value, lifespan, lifespanUnit){

                @Override
                public void execute(AggregateCompletionStage<Void> stage) {
                    stage.dependsOn((CompletionStage)InfinispanKeycloakTransaction.decorateCache(cache).replaceAsync(key, this.value, this.lifespan, this.lifespanUnit));
                }

                public String toString() {
                    return String.format("CacheTaskWithValue: Operation 'replace' for key %s, lifespan %d TimeUnit %s", new Object[]{key, this.lifespan, this.lifespanUnit});
                }
            });
        }
    }

    public <K, V> void remove(final BasicCache<K, V> cache, final K key) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REMOVE, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null) {
            if (current instanceof CacheTaskWithValue && current.getOperation() == Operation.PUT) {
                this.tasks.put(taskKey, TOMBSTONE);
                return;
            }
            if (current == TOMBSTONE) {
                return;
            }
        }
        this.tasks.put(taskKey, new CacheTask(){

            @Override
            public void execute(AggregateCompletionStage<Void> stage) {
                stage.dependsOn((CompletionStage)InfinispanKeycloakTransaction.decorateCache(cache).removeAsync(key));
            }

            public String toString() {
                return String.format("CacheTask: Operation 'remove' for key %s", key);
            }

            @Override
            public Operation getOperation() {
                return Operation.REMOVE;
            }
        });
    }

    public <K, V> V get(BasicCache<K, V> cache, K key) {
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null && current instanceof CacheTaskWithValue) {
            return ((CacheTaskWithValue)current).getValue();
        }
        return (V)cache.get(key);
    }

    private static <K, V> Object getTaskKey(BasicCache<K, V> cache, K key) {
        return key instanceof String ? cache.getName() + "::" + String.valueOf(key) : key;
    }

    private static <K, V> BasicCache<K, V> decorateCache(BasicCache<K, V> cache) {
        AdvancedCache advancedCache;
        if (cache instanceof Cache) {
            Cache c = (Cache)cache;
            advancedCache = c.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_REMOTE_LOOKUP});
        } else {
            advancedCache = cache;
        }
        return advancedCache;
    }

    private static interface CacheTask {
        public void execute(AggregateCompletionStage<Void> var1);

        default public Operation getOperation() {
            return Operation.OTHER;
        }
    }

    private static enum CacheOperation {
        ADD_WITH_LIFESPAN,
        REMOVE,
        REPLACE;

    }

    private static abstract class CacheTaskWithValue<V>
    implements CacheTask {
        protected V value;
        protected long lifespan;
        protected TimeUnit lifespanUnit;

        public CacheTaskWithValue(V value, long lifespan, TimeUnit lifespanUnit) {
            this.value = value;
            this.lifespan = lifespan;
            this.lifespanUnit = lifespanUnit;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public void updateLifespan(long lifespan, TimeUnit lifespanUnit) {
            this.lifespan = lifespan;
            this.lifespanUnit = lifespanUnit;
        }
    }

    private static enum Operation {
        PUT,
        REMOVE,
        OTHER;

    }
}

