/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote.transaction;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.ConditionalRemover;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;

class RemoteInfinispanKeycloakTransaction<K, V, R extends ConditionalRemover<K, V>>
implements NonBlockingTransaction {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<K, Operation<K, V>> tasks = new LinkedHashMap<K, Operation<K, V>>();
    private final RemoteCache<K, V> cache;
    private final R conditionalRemover;
    private static final Operation<?, ?> TOMBSTONE = new Operation<Object, Object>(){

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public Object getCacheKey() {
            return null;
        }

        @Override
        public CompletionStage<?> execute(RemoteCache<Object, Object> cache) {
            return CompletableFutures.completedNull();
        }
    };

    RemoteInfinispanKeycloakTransaction(RemoteCache<K, V> cache, R conditionalRemover) {
        this.cache = Objects.requireNonNull(cache);
        this.conditionalRemover = (ConditionalRemover)Objects.requireNonNull(conditionalRemover);
    }

    @Override
    public void asyncCommit(AggregateCompletionStage<Void> stage, Consumer<DatabaseUpdate> databaseUpdates) {
        this.conditionalRemover.executeRemovals(this.cache, stage);
        this.tasks.values().stream().filter(this::shouldCommitOperation).map(this::commitOperation).forEach(arg_0 -> stage.dependsOn(arg_0));
    }

    @Override
    public void asyncRollback(AggregateCompletionStage<Void> stage) {
        this.tasks.clear();
    }

    public void put(K key, V value, long lifespan, TimeUnit timeUnit) {
        logger.tracef("Adding %s.put(%S)", (Object)this.cache.getName(), key);
        if (this.tasks.containsKey(key)) {
            throw new IllegalStateException("Can't add entry: task " + String.valueOf(this.tasks.get(key)) + " in progress for session");
        }
        this.tasks.put(key, new PutOperation<K, V>(key, value, lifespan, timeUnit));
    }

    public void replace(K key, V value, int lifespan, TimeUnit timeUnit) {
        logger.tracef("Adding %s.replace(%S)", (Object)this.cache.getName(), key);
        Operation<K, V> existing = this.tasks.get(key);
        if (existing != null) {
            if (existing.hasValue()) {
                this.tasks.put(key, existing.update(value, lifespan, timeUnit));
            } else if (existing != TOMBSTONE && !(existing instanceof RemoveOperation)) {
                throw new IllegalStateException("Can't replace entry: task " + String.valueOf(existing) + " in progress for session");
            }
            return;
        }
        this.tasks.put(key, new ReplaceOperation<K, V>(key, value, lifespan, timeUnit));
    }

    public void remove(K key) {
        logger.tracef("Adding %s.remove(%S)", (Object)this.cache.getName(), key);
        Operation<K, V> existing = this.tasks.get(key);
        if (existing != null && existing.canRemove()) {
            this.tasks.put(key, TOMBSTONE);
            return;
        }
        this.tasks.put(key, new RemoveOperation(key));
    }

    public V get(K key) {
        Operation<K, V> existing = this.tasks.get(key);
        if (existing != null && existing.hasValue()) {
            return existing.getValue();
        }
        return (V)this.cache.get(key);
    }

    public RemoteCache<K, V> getCache() {
        return this.cache;
    }

    R getConditionalRemover() {
        return this.conditionalRemover;
    }

    private boolean shouldCommitOperation(Operation<K, V> operation) {
        return !operation.hasValue() || !this.conditionalRemover.willRemove(operation.getCacheKey(), operation.getValue());
    }

    private CompletionStage<?> commitOperation(Operation<K, V> operation) {
        try {
            return operation.execute(this.cache);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private record PutOperation<K, V>(K key, V value, long lifespan, TimeUnit timeUnit) implements Operation<K, V>
    {
        @Override
        public CompletionStage<?> execute(RemoteCache<K, V> cache) {
            return cache.putAsync(this.key, this.value, this.lifespan, this.timeUnit);
        }

        @Override
        public Operation<K, V> update(V newValue, int newLifespan, TimeUnit newTimeUnit) {
            return new PutOperation<K, V>(this.key, newValue, newLifespan, newTimeUnit);
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public K getCacheKey() {
            return this.key;
        }
    }

    private static interface Operation<K, V> {
        public CompletionStage<?> execute(RemoteCache<K, V> var1);

        default public Operation<K, V> update(V newValue, int newLifespan, TimeUnit newTimeUnit) {
            return null;
        }

        default public boolean canRemove() {
            return false;
        }

        default public boolean hasValue() {
            return false;
        }

        default public V getValue() {
            return null;
        }

        public K getCacheKey();
    }

    private record RemoveOperation<K, V>(K key) implements Operation<K, V>
    {
        @Override
        public CompletionStage<?> execute(RemoteCache<K, V> cache) {
            return cache.removeAsync(this.key);
        }

        @Override
        public K getCacheKey() {
            return this.key;
        }
    }

    private record ReplaceOperation<K, V>(K key, V value, long lifespan, TimeUnit timeUnit) implements Operation<K, V>
    {
        @Override
        public CompletionStage<?> execute(RemoteCache<K, V> cache) {
            return cache.replaceAsync(this.key, this.value, this.lifespan, this.timeUnit);
        }

        @Override
        public Operation<K, V> update(V newValue, int newLifespan, TimeUnit newTimeUnit) {
            return new ReplaceOperation<K, V>(this.key, newValue, newLifespan, newTimeUnit);
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public K getCacheKey() {
            return this.key;
        }
    }
}

