/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.sdjwt.DecoyClaim;
import org.keycloak.sdjwt.Disclosable;
import org.keycloak.sdjwt.SdJws;
import org.keycloak.sdjwt.SdJwtClaim;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.UndisclosedClaim;

public class IssuerSignedJWT
extends SdJws {
    public static final String CLAIM_NAME_SELECTIVE_DISCLOSURE = "_sd";
    public static final String CLAIM_NAME_SD_HASH_ALGORITHM = "_sd_alg";

    public IssuerSignedJWT(JsonNode payload, SignatureSignerContext signer, String jwsType) {
        super(payload, signer, jwsType);
    }

    public static IssuerSignedJWT fromJws(String jwsString) {
        return new IssuerSignedJWT(jwsString);
    }

    private IssuerSignedJWT(String jwsString) {
        super(jwsString);
    }

    private IssuerSignedJWT(List<SdJwtClaim> claims, List<DecoyClaim> decoyClaims, String hashAlg, boolean nestedDisclosures) {
        super(IssuerSignedJWT.generatePayloadString(claims, decoyClaims, hashAlg, nestedDisclosures));
    }

    private IssuerSignedJWT(JsonNode payload, JWSInput jwsInput) {
        super(payload, jwsInput);
    }

    private IssuerSignedJWT(List<SdJwtClaim> claims, List<DecoyClaim> decoyClaims, String hashAlg, boolean nestedDisclosures, SignatureSignerContext signer, String jwsType) {
        super(IssuerSignedJWT.generatePayloadString(claims, decoyClaims, hashAlg, nestedDisclosures), signer, jwsType);
    }

    private static JsonNode generatePayloadString(List<SdJwtClaim> claims, List<DecoyClaim> decoyClaims, String hashAlg, boolean nestedDisclosures) {
        SdJwtUtils.requireNonEmpty(hashAlg, "hashAlg must not be null or empty");
        List<Object> claimsInternal = claims == null ? Collections.emptyList() : Collections.unmodifiableList(claims);
        List<Object> decoyClaimsInternal = decoyClaims == null ? Collections.emptyList() : Collections.unmodifiableList(decoyClaims);
        try {
            claimsInternal.stream().filter(Objects::nonNull).collect(Collectors.toMap(SdJwtClaim::getClaimName, claim -> claim));
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("claims must not contain duplicate claim names", e);
        }
        ArrayNode sdArray = SdJwtUtils.mapper.createArrayNode();
        List digests = claimsInternal.stream().filter(claim -> claim instanceof UndisclosedClaim).map(claim -> (UndisclosedClaim)claim).collect(Collectors.toMap(Disclosable::getSalt, claim -> claim)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).filter(Objects::nonNull).map(od -> od.getDisclosureDigest(hashAlg)).collect(Collectors.toList());
        decoyClaimsInternal.stream().map(claim -> claim.getDisclosureDigest(hashAlg)).forEach(digests::add);
        digests.stream().sorted().forEach(arg_0 -> ((ArrayNode)sdArray).add(arg_0));
        ObjectNode payload = SdJwtUtils.mapper.createObjectNode();
        if (sdArray.size() > 0) {
            payload.set(CLAIM_NAME_SELECTIVE_DISCLOSURE, (JsonNode)sdArray);
        }
        if (sdArray.size() > 0 || nestedDisclosures) {
            payload.put(CLAIM_NAME_SD_HASH_ALGORITHM, hashAlg);
        }
        claimsInternal.stream().filter(Objects::nonNull).filter(claim -> !(claim instanceof UndisclosedClaim)).forEach(nullableClaim -> {
            SdJwtClaim claim = Objects.requireNonNull(nullableClaim);
            payload.set(claim.getClaimNameAsString(), claim.getVisibleClaimValue(hashAlg));
        });
        return payload;
    }

    public Optional<JsonNode> getCnfClaim() {
        JsonNode cnf = this.getPayload().get("cnf");
        return Optional.ofNullable(cnf);
    }

    public String getSdHashAlg() {
        JsonNode hashAlgNode = this.getPayload().get(CLAIM_NAME_SD_HASH_ALGORITHM);
        return hashAlgNode == null ? "sha-256" : hashAlgNode.asText();
    }

    public void verifySdHashAlgorithm() throws VerificationException {
        String hashAlg;
        HashSet<String> secureAlgorithms = new HashSet<String>(Arrays.asList("sha-256", "sha-384", "sha-512", "sha3-256", "sha3-384", "sha3-512"));
        if (!secureAlgorithms.contains(hashAlg = this.getSdHashAlg())) {
            throw new VerificationException("Unexpected or insecure hash algorithm: " + hashAlg);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<SdJwtClaim> claims;
        private String hashAlg;
        private SignatureSignerContext signer;
        private List<DecoyClaim> decoyClaims;
        private boolean nestedDisclosures;
        private String jwsType;

        public Builder withClaims(List<SdJwtClaim> claims) {
            this.claims = claims;
            return this;
        }

        public Builder withDecoyClaims(List<DecoyClaim> decoyClaims) {
            this.decoyClaims = decoyClaims;
            return this;
        }

        public Builder withHashAlg(String hashAlg) {
            this.hashAlg = hashAlg;
            return this;
        }

        public Builder withSigner(SignatureSignerContext signer) {
            this.signer = signer;
            return this;
        }

        public Builder withNestedDisclosures(boolean nestedDisclosures) {
            this.nestedDisclosures = nestedDisclosures;
            return this;
        }

        public Builder withJwsType(String jwsType) {
            this.jwsType = jwsType;
            return this;
        }

        public IssuerSignedJWT build() {
            this.hashAlg = this.hashAlg == null ? "sha-256" : this.hashAlg;
            this.jwsType = this.jwsType == null ? "dc+sd-jwt" : this.jwsType;
            this.claims = this.claims == null ? Collections.emptyList() : this.claims;
            List<Object> list = this.decoyClaims = this.decoyClaims == null ? Collections.emptyList() : this.decoyClaims;
            if (this.signer != null) {
                return new IssuerSignedJWT(this.claims, this.decoyClaims, this.hashAlg, this.nestedDisclosures, this.signer, this.jwsType);
            }
            return new IssuerSignedJWT(this.claims, this.decoyClaims, this.hashAlg, this.nestedDisclosures);
        }
    }
}

