/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sbom;

import io.quarkus.sbom.ApplicationComponent;
import io.quarkus.sbom.ApplicationManifestConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationManifest {
    protected ApplicationComponent mainComponent;
    protected Collection<ApplicationComponent> components;
    protected Path runnerPath;

    public static ApplicationManifest fromConfig(ApplicationManifestConfig config) {
        Object builder;
        if (config.getDistributionDirectory() != null) {
            builder = ApplicationManifestConfig.builder().setDistributionDirectory(config.getDistributionDirectory()).setMainComponent(config.getMainComponent()).setRunnerPath(config.getRunnerPath());
            for (ApplicationComponent c : config.getComponents()) {
                ((ApplicationManifestConfig.Builder)builder).addComponent(c);
            }
            ApplicationManifest.addRemainingContent(config, (ApplicationManifestConfig.Builder)builder);
            config = ((ApplicationManifestConfig.Builder)builder).build();
        }
        builder = ApplicationManifest.builder();
        ((Builder)builder).setMainComponent(config.getMainComponent()).setRunnerPath(config.getRunnerPath());
        for (ApplicationComponent c : config.getComponents()) {
            ((Builder)builder).addComponent(c);
        }
        return ((Builder)builder).build();
    }

    private static void addRemainingContent(ApplicationManifestConfig config, final ApplicationManifestConfig.Builder builder) {
        try {
            Files.walkFileTree(config.getDistributionDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    builder.addComponent(ApplicationComponent.builder().setPath(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private ApplicationManifest() {
    }

    private ApplicationManifest(ApplicationManifest builder) {
        if (builder.mainComponent == null) {
            throw new IllegalArgumentException("Main component is null");
        }
        this.mainComponent = builder.mainComponent.ensureImmutable();
        if (builder.components == null || builder.components.isEmpty()) {
            this.components = List.of();
        } else {
            ApplicationComponent[] tmp = new ApplicationComponent[builder.components.size()];
            int i = 0;
            for (ApplicationComponent c : builder.components) {
                tmp[i++] = c.ensureImmutable();
            }
            this.components = List.of(tmp);
        }
        this.runnerPath = builder.runnerPath;
    }

    public ApplicationComponent getMainComponent() {
        return this.mainComponent;
    }

    public Collection<ApplicationComponent> getComponents() {
        return this.components == null ? List.of() : this.components;
    }

    public Path getRunnerPath() {
        return this.runnerPath;
    }

    public static class Builder
    extends ApplicationManifest {
        private Builder() {
        }

        private Builder(ApplicationManifest manifest) {
            super(manifest);
        }

        public Builder setMainComponent(ApplicationComponent main) {
            this.mainComponent = main;
            return this;
        }

        public Builder addComponent(ApplicationComponent component) {
            if (component == null) {
                throw new IllegalArgumentException("component is null");
            }
            if (this.components == null) {
                this.components = new ArrayList();
            }
            this.components.add(component);
            return this;
        }

        public Builder setRunnerPath(Path runnerPath) {
            this.runnerPath = runnerPath;
            return this;
        }

        public ApplicationManifest build() {
            return new ApplicationManifest(this);
        }
    }
}

