/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.spiffe;

import java.util.regex.Pattern;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderShowInAccountConsole;
import org.keycloak.models.RealmModel;

public class SpiffeIdentityProviderConfig
extends IdentityProviderModel {
    public static final String BUNDLE_ENDPOINT_KEY = "bundleEndpoint";
    private static final Pattern TRUST_DOMAIN_PATTERN = Pattern.compile("spiffe://[a-z0-9.\\-_]*");

    public SpiffeIdentityProviderConfig() {
        this.getConfig().put("showInAccountConsole", IdentityProviderShowInAccountConsole.NEVER.name());
    }

    public SpiffeIdentityProviderConfig(IdentityProviderModel model) {
        super(model);
    }

    public boolean isHideOnLogin() {
        return true;
    }

    public int getAllowedClockSkew() {
        String allowedClockSkew = (String)this.getConfig().get("allowedClockSkew");
        if (allowedClockSkew == null || allowedClockSkew.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt((String)this.getConfig().get("allowedClockSkew"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getTrustDomain() {
        return (String)this.getConfig().get("issuer");
    }

    public String getBundleEndpoint() {
        return (String)this.getConfig().get(BUNDLE_ENDPOINT_KEY);
    }

    public void validate(RealmModel realm) {
        super.validate(realm);
        String trustDomain = this.getTrustDomain();
        if (trustDomain == null || !TRUST_DOMAIN_PATTERN.matcher(trustDomain).matches()) {
            throw new IllegalArgumentException("Invalid trust domain name");
        }
        UriUtils.checkUrl((SslRequired)realm.getSslRequired(), (String)this.getBundleEndpoint(), (String)BUNDLE_ENDPOINT_KEY);
    }
}

