/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.forms.login.freemarker.model;

import java.util.List;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.forms.login.freemarker.model.AuthenticationContextBean;

public class OrganizationAwareAuthenticationContextBean
extends AuthenticationContextBean {
    private final AuthenticationContextBean delegate;
    private final boolean showTryAnotherWayLink;
    private final String username;

    public OrganizationAwareAuthenticationContextBean(AuthenticationContextBean delegate, boolean showTryAnotherWayLink) {
        this(delegate, showTryAnotherWayLink, null);
    }

    public OrganizationAwareAuthenticationContextBean(AuthenticationContextBean delegate, boolean showTryAnotherWayLink, String username) {
        super(null, null);
        this.delegate = delegate;
        this.showTryAnotherWayLink = showTryAnotherWayLink;
        this.username = username;
    }

    @Override
    public List<AuthenticationSelectionOption> getAuthenticationSelections() {
        return this.delegate.getAuthenticationSelections();
    }

    @Override
    public boolean showTryAnotherWayLink() {
        if (this.showTryAnotherWayLink) {
            return this.delegate.showTryAnotherWayLink();
        }
        return false;
    }

    @Override
    public boolean showUsername() {
        return this.username != null || this.delegate.showUsername();
    }

    @Override
    public boolean showResetCredentials() {
        return this.delegate.showResetCredentials();
    }

    @Override
    public String getAttemptedUsername() {
        if (this.username == null) {
            return this.delegate.getAttemptedUsername();
        }
        return this.username;
    }
}

