/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.AbstractCancellableServerRestHandler;

public class UniResponseHandler
extends AbstractCancellableServerRestHandler {
    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        Object object = requestContext.getResult();
        if (object instanceof Uni) {
            Uni result = (Uni)object;
            requestContext.suspend();
            final AtomicBoolean done = new AtomicBoolean(false);
            final Cancellable cancellable = result.subscribe().with((Consumer)new Consumer<Object>(){

                @Override
                public void accept(Object v) {
                    if (done.compareAndSet(false, true)) {
                        requestContext.setResult(v);
                        requestContext.resume();
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable t) {
                    if (done.compareAndSet(false, true)) {
                        requestContext.resume(t, true);
                    }
                }
            });
            requestContext.serverResponse().addCloseHandler(new Runnable(){

                @Override
                public void run() {
                    if (UniResponseHandler.this.isCancellable() && done.compareAndSet(false, true)) {
                        cancellable.cancel();
                        try {
                            requestContext.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

