/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCommitUpdateEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.TypeHelper;

public class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private final NaturalIdMapping naturalIdMapping;
    private final Object previousNaturalIdValues;
    private Object nextVersion;
    private Object cacheEntry;
    private SoftLock lock;

    public EntityUpdateAction(Object id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, EventSource session) {
        super(session, id, instance, persister);
        this.state = state;
        this.previousState = previousState;
        this.previousVersion = previousVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.hasDirtyCollection = hasDirtyCollection;
        this.rowId = rowId;
        this.naturalIdMapping = persister.getNaturalIdMapping();
        if (this.naturalIdMapping == null) {
            this.previousNaturalIdValues = null;
        } else {
            this.previousNaturalIdValues = EntityUpdateAction.determinePreviousNaturalIdValues(persister, this.naturalIdMapping, id, previousState, session);
            session.getPersistenceContextInternal().getNaturalIdResolutions().manageLocalResolution(id, this.naturalIdMapping.extractNaturalIdFromEntityState(state), persister, CachedNaturalIdValueSource.UPDATE);
        }
    }

    private static Object determinePreviousNaturalIdValues(EntityPersister persister, NaturalIdMapping naturalIdMapping, Object id, Object[] previousState, SharedSessionContractImplementor session) {
        return previousState == null ? session.getPersistenceContextInternal().getNaturalIdSnapshot(id, persister) : naturalIdMapping.extractNaturalIdFromEntityState(previousState);
    }

    protected Object[] getState() {
        return this.state;
    }

    protected Object[] getPreviousState() {
        return this.previousState;
    }

    protected Object getNextVersion() {
        return this.nextVersion;
    }

    protected int[] getDirtyFields() {
        return this.dirtyFields;
    }

    protected boolean hasDirtyCollection() {
        return this.hasDirtyCollection;
    }

    protected NaturalIdMapping getNaturalIdMapping() {
        return this.naturalIdMapping;
    }

    protected Object getPreviousNaturalIdValues() {
        return this.previousNaturalIdValues;
    }

    public Object getRowId() {
        return this.rowId;
    }

    protected void setLock(SoftLock lock) {
        this.lock = lock;
    }

    protected void setCacheEntry(Object cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws HibernateException {
        if (!this.preUpdate()) {
            GeneratedValues generatedValues;
            EntityPersister persister = this.getPersister();
            EventSource session = this.getSession();
            Object id = this.getId();
            Object instance = this.getInstance();
            Object previousVersion = this.getPreviousVersion();
            Object ck = this.lockCacheItem(previousVersion);
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityUpdateEvent();
            boolean success = false;
            try {
                generatedValues = persister.getUpdateCoordinator().update(instance, id, this.rowId, this.state, previousVersion, this.previousState, this.dirtyFields, this.hasDirtyCollection, session);
                success = true;
            }
            finally {
                eventMonitor.completeEntityUpdateEvent(event, id, persister.getEntityName(), success, session);
            }
            EntityEntry entry = session.getPersistenceContextInternal().getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non thread safe access to session");
            }
            this.handleGeneratedProperties(entry, generatedValues);
            this.handleDeleted(entry);
            this.updateCacheItem(previousVersion, ck, entry);
            this.handleNaturalIdResolutions(persister, session, id);
            this.postUpdate();
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.updateEntity(this.getPersister().getEntityName());
            }
        }
    }

    protected void handleNaturalIdResolutions(EntityPersister persister, SharedSessionContractImplementor session, Object id) {
        if (this.naturalIdMapping != null) {
            session.getPersistenceContextInternal().getNaturalIdResolutions().manageSharedResolution(id, this.naturalIdMapping.extractNaturalIdFromEntityState(this.state), this.previousNaturalIdValues, persister, CachedNaturalIdValueSource.UPDATE);
        }
    }

    protected void updateCacheItem(Object previousVersion, Object ck, EntityEntry entry) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EventSource session = this.getSession();
            if (EntityUpdateAction.isCacheInvalidationRequired(persister, session) || entry.getStatus() != Status.MANAGED) {
                persister.getCacheAccessStrategy().remove(session, ck);
            } else if (session.getCacheMode().isPutEnabled()) {
                CacheEntry ce = persister.buildCacheEntry(this.getInstance(), this.state, this.nextVersion, this.getSession());
                this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
                boolean put = this.updateCache(persister, previousVersion, ck);
                StatisticsImplementor statistics = session.getFactory().getStatistics();
                if (put && statistics.isStatisticsEnabled()) {
                    statistics.entityCachePut(StatsHelper.getRootEntityRole(persister), this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
    }

    private static boolean isCacheInvalidationRequired(EntityPersister persister, SharedSessionContractImplementor session) {
        return persister.isCacheInvalidationRequired() || session.getCacheMode() == CacheMode.GET || session.getCacheMode() == CacheMode.IGNORE;
    }

    private void handleGeneratedProperties(EntityEntry entry, GeneratedValues generatedValues) {
        EntityPersister persister = this.getPersister();
        if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
            EventSource session = this.getSession();
            Object instance = this.getInstance();
            Object id = this.getId();
            TypeHelper.deepCopy(this.state, persister.getPropertyTypes(), persister.getPropertyCheckability(), this.state, session);
            if (persister.hasUpdateGeneratedProperties()) {
                persister.processUpdateGeneratedProperties(id, instance, this.state, generatedValues, session);
            }
            if (persister.isVersionPropertyGenerated()) {
                this.nextVersion = Versioning.getVersion(this.state, persister);
            }
            entry.postUpdate(instance, this.state, this.nextVersion);
            entry.setMaybeLazySet(null);
        }
    }

    protected void handleDeleted(EntityEntry entry) {
        if (entry.getStatus() == Status.DELETED) {
            boolean isImpliedOptimisticLocking;
            EntityMetamodel entityMetamodel = this.getPersister().getEntityMetamodel();
            boolean bl = isImpliedOptimisticLocking = !entityMetamodel.isVersioned() && entityMetamodel.getOptimisticLockStyle().isAllOrDirty();
            if (isImpliedOptimisticLocking && entry.getLoadedState() != null) {
                entry.postUpdate(this.getInstance(), this.state, this.nextVersion);
            }
        }
    }

    protected Object getPreviousVersion() {
        EntityPersister persister = this.getPersister();
        if (persister.isVersionPropertyGenerated()) {
            return persister.getVersion(this.getInstance());
        }
        return this.previousVersion;
    }

    protected Object lockCacheItem(Object previousVersion) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EventSource session = this.getSession();
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(this.getId(), persister, session.getFactory(), session.getTenantIdentifier());
            this.lock = cache.lockItem(session, ck, previousVersion);
            return ck;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateCache(EntityPersister persister, Object previousVersion, Object ck) {
        EventSource session = this.getSession();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        EntityDataAccess cacheAccessStrategy = persister.getCacheAccessStrategy();
        boolean update = false;
        try {
            session.getEventListenerManager().cachePutStart();
            boolean bl = update = cacheAccessStrategy.update(session, ck, this.cacheEntry, this.nextVersion, previousVersion);
            return bl;
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, (SharedSessionContractImplementor)session, (CachedDomainDataAccess)cacheAccessStrategy, this.getPersister(), update, EventMonitor.CacheActionDescription.ENTITY_UPDATE);
            session.getEventListenerManager().cachePutEnd();
        }
    }

    protected boolean preUpdate() {
        EventListenerGroup<PreUpdateEventListener> listenerGroup = this.getEventListenerGroups().eventListenerGroup_PRE_UPDATE;
        if (listenerGroup.isEmpty()) {
            return false;
        }
        PreUpdateEvent event = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), this.eventSource());
        boolean veto = false;
        for (PreUpdateEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreUpdate(event);
        }
        return veto;
    }

    protected void postUpdate() {
        this.getEventListenerGroups().eventListenerGroup_POST_UPDATE.fireLazyEventOnEachListener(this::newPostUpdateEvent, PostUpdateEventListener::onPostUpdate);
    }

    private PostUpdateEvent newPostUpdateEvent() {
        return new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getPersister(), this.eventSource());
    }

    protected void postCommitUpdate(boolean success) {
        this.getEventListenerGroups().eventListenerGroup_POST_COMMIT_UPDATE.fireLazyEventOnEachListener(this::newPostUpdateEvent, success ? PostUpdateEventListener::onPostUpdate : this::onPostCommitFailure);
    }

    private void onPostCommitFailure(PostUpdateEventListener listener, PostUpdateEvent event) {
        if (listener instanceof PostCommitUpdateEventListener) {
            PostCommitUpdateEventListener postCommitUpdateEventListener = (PostCommitUpdateEventListener)listener;
            postCommitUpdateEventListener.onPostUpdateCommitFailed(event);
        } else {
            listener.onPostUpdate(event);
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostUpdateEventListener> group = this.getEventListenerGroups().eventListenerGroup_POST_COMMIT_UPDATE;
        for (PostUpdateEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws CacheException {
        this.updateCacheIfNecessary(success, session);
        this.postCommitUpdate(success);
    }

    private void updateCacheIfNecessary(boolean success, SharedSessionContractImplementor session) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            SessionFactoryImplementor factory = session.getFactory();
            Object ck = cache.generateCacheKey(this.getId(), persister, factory, session.getTenantIdentifier());
            if (this.cacheUpdateRequired(success, persister, session)) {
                this.cacheAfterUpdate(cache, ck, session);
            } else {
                cache.unlockItem(session, ck, this.lock);
            }
        }
    }

    private boolean cacheUpdateRequired(boolean success, EntityPersister persister, SharedSessionContractImplementor session) {
        return success && this.cacheEntry != null && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheAfterUpdate(EntityDataAccess cache, Object ck, SharedSessionContractImplementor session) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        boolean put = false;
        try {
            eventListenerManager.cachePutStart();
            put = cache.afterUpdate(session, ck, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cache, this.getPersister(), put, EventMonitor.CacheActionDescription.ENTITY_AFTER_UPDATE);
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(StatsHelper.getRootEntityRole(this.getPersister()), cache.getRegion().getName());
            }
            eventListenerManager.cachePutEnd();
        }
    }
}

