/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.util.Locale;
import java.util.UUID;
import org.hibernate.MappingException;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AbstractEntityIdGeneratorResolver;
import org.hibernate.boot.model.internal.GeneratorAnnotationHelper;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.GeneratorStrategies;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.GenericGeneratorAnnotation;
import org.hibernate.boot.models.spi.GenericGeneratorRegistration;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.spi.SequenceGeneratorRegistration;
import org.hibernate.boot.models.spi.TableGeneratorRegistration;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.generator.Generator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.MemberDetails;

public class IdGeneratorResolverSecondPass
extends AbstractEntityIdGeneratorResolver {
    public IdGeneratorResolverSecondPass(PersistentClass entityMapping, SimpleValue idValue, MemberDetails idMember, GeneratedValue generatedValue, MetadataBuildingContext buildingContext) {
        super(entityMapping, idValue, idMember, generatedValue, buildingContext);
    }

    @Override
    protected void handleUnnamedSequenceGenerator() {
        SequenceGenerator localizedMatch = (SequenceGenerator)GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.SEQUENCE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), null, null, this.buildingContext);
        if (localizedMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(null, localizedMatch, this.idValue, this.idMember, this.buildingContext);
            return;
        }
        GeneratorAnnotationHelper.handleSequenceGenerator(null, null, this.idValue, this.idMember, this.buildingContext);
    }

    @Override
    protected void handleNamedSequenceGenerator() {
        String generator = this.generatedValue.generator();
        SequenceGenerator localizedMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.SEQUENCE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), SequenceGenerator::name, generator, this.buildingContext);
        if (localizedMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(generator, localizedMatch, this.idValue, this.idMember, this.buildingContext);
            return;
        }
        SequenceGeneratorRegistration globalMatch = this.buildingContext.getMetadataCollector().getGlobalRegistrations().getSequenceGeneratorRegistrations().get(generator);
        if (globalMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(generator, globalMatch.configuration(), this.idValue, this.idMember, this.buildingContext);
            return;
        }
        this.validateSequenceGeneration();
        GeneratorAnnotationHelper.handleSequenceGenerator(generator, null, this.idValue, this.idMember, this.buildingContext);
    }

    private void validateSequenceGeneration() {
        GlobalRegistrations globalRegistrations = this.buildingContext.getMetadataCollector().getGlobalRegistrations();
        String generator = this.generatedValue.generator();
        TableGeneratorRegistration globalTableMatch = globalRegistrations.getTableGeneratorRegistrations().get(generator);
        if (globalTableMatch != null) {
            throw new MappingException(String.format(Locale.ROOT, "@GeneratedValue for %s (%s) specified SEQUENCE generation, but referred to a @TableGenerator", this.entityMapping.getEntityName(), generator));
        }
        GenericGeneratorRegistration globalGenericMatch = globalRegistrations.getGenericGeneratorRegistrations().get(generator);
        if (globalGenericMatch != null) {
            throw new MappingException(String.format(Locale.ROOT, "@GeneratedValue for %s (%s) specified SEQUENCE generation, but referred to a @GenericGenerator", this.entityMapping.getEntityName(), generator));
        }
    }

    @Override
    protected void handleUnnamedTableGenerator() {
        TableGenerator localizedMatch = (TableGenerator)GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.TABLE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), null, null, this.buildingContext);
        this.handleTableGenerator(null, localizedMatch);
    }

    @Override
    protected void handleNamedTableGenerator() {
        String generator = this.generatedValue.generator();
        TableGenerator localizedTableMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.TABLE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), TableGenerator::name, generator, this.buildingContext);
        if (localizedTableMatch != null) {
            this.handleTableGenerator(generator, localizedTableMatch);
            return;
        }
        TableGeneratorRegistration globalMatch = this.buildingContext.getMetadataCollector().getGlobalRegistrations().getTableGeneratorRegistrations().get(generator);
        if (globalMatch != null) {
            this.handleTableGenerator(generator, globalMatch.configuration());
            return;
        }
        this.validateTableGeneration();
        this.handleTableGenerator(generator, null);
    }

    private void validateTableGeneration() {
        GlobalRegistrations globalRegistrations = this.buildingContext.getMetadataCollector().getGlobalRegistrations();
        String generator = this.generatedValue.generator();
        SequenceGeneratorRegistration globalSequenceMatch = globalRegistrations.getSequenceGeneratorRegistrations().get(generator);
        if (globalSequenceMatch != null) {
            throw new MappingException(String.format(Locale.ROOT, "@GeneratedValue for %s (%s) specified TABLE generation, but referred to a @SequenceGenerator", this.entityMapping.getEntityName(), generator));
        }
        GenericGeneratorRegistration globalGenericMatch = globalRegistrations.getGenericGeneratorRegistrations().get(generator);
        if (globalGenericMatch != null) {
            throw new MappingException(String.format(Locale.ROOT, "@GeneratedValue for %s (%s) specified TABLE generation, but referred to a @GenericGenerator", this.entityMapping.getEntityName(), generator));
        }
    }

    @Override
    protected void handleUnnamedAutoGenerator() {
        SequenceGenerator localizedSequenceMatch = (SequenceGenerator)GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.SEQUENCE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), null, null, this.buildingContext);
        if (localizedSequenceMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(null, localizedSequenceMatch, this.idValue, this.idMember, this.buildingContext);
            return;
        }
        TableGenerator localizedTableMatch = (TableGenerator)GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.TABLE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), null, null, this.buildingContext);
        if (localizedTableMatch != null) {
            this.handleTableGenerator(null, localizedTableMatch);
            return;
        }
        GenericGenerator localizedGenericMatch = (GenericGenerator)GeneratorAnnotationHelper.findLocalizedMatch(HibernateAnnotations.GENERIC_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), null, null, this.buildingContext);
        if (localizedGenericMatch != null) {
            GeneratorAnnotationHelper.handleGenericGenerator(this.entityMapping.getJpaEntityName(), localizedGenericMatch, this.entityMapping, this.idValue, this.buildingContext);
            return;
        }
        if (this.handleAsMetaAnnotated()) {
            return;
        }
        if (this.idMember.getType().isImplementor(UUID.class) || this.idMember.getType().isImplementor(String.class)) {
            GeneratorAnnotationHelper.handleUuidStrategy(this.idValue, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), this.buildingContext);
            return;
        }
        if (this.handleAsLegacyGenerator()) {
            return;
        }
        GeneratorAnnotationHelper.handleSequenceGenerator(null, null, this.idValue, this.idMember, this.buildingContext);
    }

    @Override
    protected void handleNamedAutoGenerator() {
        if (this.handleAsLocalAutoGenerator()) {
            return;
        }
        if (this.handleAsNamedGlobalAutoGenerator()) {
            return;
        }
        String generator = this.generatedValue.generator();
        Class<? extends Generator> legacyNamedGenerator = GeneratorStrategies.mapLegacyNamedGenerator(generator, this.buildingContext);
        if (legacyNamedGenerator != null) {
            GeneratorBinder.createGeneratorFrom(new IdentifierGeneratorDefinition(generator, legacyNamedGenerator.getName()), this.idValue, this.buildingContext);
            return;
        }
        if (this.handleAsMetaAnnotated()) {
            return;
        }
        if (this.idMember.getType().isImplementor(UUID.class) || this.idMember.getType().isImplementor(String.class)) {
            GeneratorAnnotationHelper.handleUuidStrategy(this.idValue, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), this.buildingContext);
            return;
        }
        if (this.handleAsLegacyGenerator()) {
            return;
        }
        GeneratorAnnotationHelper.handleSequenceGenerator(generator, null, this.idValue, this.idMember, this.buildingContext);
    }

    private boolean handleAsLocalAutoGenerator() {
        if ("increment".equals(this.generatedValue.generator())) {
            GenericGeneratorAnnotation incrementGenerator = new GenericGeneratorAnnotation(this.buildingContext.getBootstrapContext().getModelsContext());
            incrementGenerator.name("increment");
            incrementGenerator.strategy("increment");
            GeneratorAnnotationHelper.handleGenericGenerator(this.generatedValue.generator(), incrementGenerator, this.entityMapping, this.idValue, this.buildingContext);
            return true;
        }
        String generator = this.generatedValue.generator();
        assert (!generator.isEmpty());
        SequenceGenerator localizedSequenceMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.SEQUENCE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), SequenceGenerator::name, generator, this.buildingContext);
        if (localizedSequenceMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(generator, localizedSequenceMatch, this.idValue, this.idMember, this.buildingContext);
            return true;
        }
        TableGenerator localizedTableMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.TABLE_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), TableGenerator::name, generator, this.buildingContext);
        if (localizedTableMatch != null) {
            this.handleTableGenerator(generator, localizedTableMatch);
            return true;
        }
        GenericGenerator localizedGenericMatch = GeneratorAnnotationHelper.findLocalizedMatch(HibernateAnnotations.GENERIC_GENERATOR, this.idMember, this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(this.entityMapping.getClassName()), GenericGenerator::name, generator, this.buildingContext);
        if (localizedGenericMatch != null) {
            GeneratorAnnotationHelper.handleGenericGenerator(generator, localizedGenericMatch, this.entityMapping, this.idValue, this.buildingContext);
            return true;
        }
        return false;
    }

    private boolean handleAsNamedGlobalAutoGenerator() {
        GlobalRegistrations globalRegistrations = this.buildingContext.getMetadataCollector().getGlobalRegistrations();
        String generator = this.generatedValue.generator();
        SequenceGeneratorRegistration globalSequenceMatch = globalRegistrations.getSequenceGeneratorRegistrations().get(generator);
        if (globalSequenceMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(generator, globalSequenceMatch.configuration(), this.idValue, this.idMember, this.buildingContext);
            return true;
        }
        TableGeneratorRegistration globalTableMatch = globalRegistrations.getTableGeneratorRegistrations().get(generator);
        if (globalTableMatch != null) {
            this.handleTableGenerator(generator, globalTableMatch.configuration());
            return true;
        }
        GenericGeneratorRegistration globalGenericMatch = globalRegistrations.getGenericGeneratorRegistrations().get(generator);
        if (globalGenericMatch != null) {
            GeneratorAnnotationHelper.handleGenericGenerator(generator, globalGenericMatch.configuration(), this.entityMapping, this.idValue, this.buildingContext);
            return true;
        }
        return false;
    }

    private void handleTableGenerator(String nameFromGeneratedValue, TableGenerator generatorAnnotation) {
        GeneratorAnnotationHelper.handleTableGenerator(nameFromGeneratedValue, generatorAnnotation, this.idValue, this.idMember, this.buildingContext);
    }
}

