/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class NamedBasicTypeResolution<J>
implements BasicValue.Resolution<J> {
    private final JavaType<J> domainJtd;
    private final BasicType<J> basicType;
    private final BasicValueConverter<J, ?> valueConverter;
    private final MutabilityPlan<J> mutabilityPlan;

    public NamedBasicTypeResolution(JavaType<J> domainJtd, BasicType<J> basicType, BasicValueConverter<J, ?> valueConverter, MutabilityPlan<J> explicitPlan) {
        this.domainJtd = domainJtd;
        this.basicType = basicType;
        this.valueConverter = valueConverter;
        this.mutabilityPlan = explicitPlan != null ? explicitPlan : domainJtd.getMutabilityPlan();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.basicType;
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.basicType;
    }

    @Override
    public JavaType<J> getDomainJavaType() {
        return this.domainJtd;
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.valueConverter == null ? this.basicType.getJavaTypeDescriptor() : this.valueConverter.getRelationalJavaType();
    }

    @Override
    public JdbcType getJdbcType() {
        return this.basicType.getJdbcType();
    }

    @Override
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }
}

