/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.AccessType;
import java.util.EnumSet;
import org.hibernate.annotations.CascadeType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitDefaultsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitMetadataImpl;
import org.hibernate.boot.models.xml.XmlProcessLogging;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.internal.util.StringHelper;

public final class PersistenceUnitMetadataImpl
implements PersistenceUnitMetadata {
    private boolean quoteIdentifiers;
    private boolean xmlComplete;
    private String defaultSchema;
    private String defaultCatalog;
    private AccessType accessType;
    private String defaultAccessStrategy;
    private final EnumSet<CascadeType> defaultCascadeTypes = EnumSet.noneOf(CascadeType.class);

    @Override
    public boolean areXmlMappingsComplete() {
        return this.xmlComplete;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public String getDefaultAccessStrategyName() {
        return this.defaultAccessStrategy;
    }

    @Override
    public EnumSet<CascadeType> getDefaultCascadeTypes() {
        return this.defaultCascadeTypes;
    }

    @Override
    public boolean useQuotedIdentifiers() {
        return this.quoteIdentifiers;
    }

    public void apply(JaxbPersistenceUnitMetadataImpl metadata) {
        if (metadata == null) {
            return;
        }
        this.xmlComplete = this.xmlComplete || metadata.getXmlMappingMetadataComplete() != null;
        JaxbPersistenceUnitDefaultsImpl defaults = metadata.getPersistenceUnitDefaults();
        if (defaults == null) {
            return;
        }
        boolean bl = this.quoteIdentifiers = this.quoteIdentifiers || defaults.getDelimitedIdentifiers() != null;
        if (StringHelper.isNotEmpty(defaults.getCatalog())) {
            if (this.defaultCatalog != null) {
                XmlProcessLogging.XML_PROCESS_LOGGER.tracef("Setting already set default catalog: %s, %s", (Object)this.defaultCatalog, (Object)defaults.getCatalog());
            }
            this.defaultCatalog = defaults.getCatalog();
        }
        if (StringHelper.isNotEmpty(defaults.getSchema())) {
            if (this.defaultSchema != null) {
                XmlProcessLogging.XML_PROCESS_LOGGER.tracef("Setting already set default schema: %s, %s", (Object)this.defaultSchema, (Object)defaults.getSchema());
            }
            this.defaultSchema = defaults.getSchema();
        }
        if (defaults.getAccess() != null) {
            if (this.accessType != null) {
                XmlProcessLogging.XML_PROCESS_LOGGER.tracef("Overriding already set default AccessType: %s, %s", (Object)defaults.getAccess(), (Object)this.accessType);
            }
            this.accessType = defaults.getAccess();
        }
        if (StringHelper.isNotEmpty(defaults.getDefaultAccess())) {
            if (this.defaultAccessStrategy != null) {
                XmlProcessLogging.XML_PROCESS_LOGGER.tracef("Overriding already set default access strategy: %s, %s", (Object)this.accessType, (Object)this.defaultAccessStrategy);
            }
            this.defaultAccessStrategy = defaults.getDefaultAccess();
        }
        if (defaults.getCascadePersist() != null || StringHelper.isNotEmpty(defaults.getDefaultCascade())) {
            if (!this.defaultCascadeTypes.isEmpty()) {
                XmlProcessLogging.XML_PROCESS_LOGGER.tracef("Adding cascades to already defined set of default cascades", new Object[0]);
            }
            if (defaults.getCascadePersist() != null) {
                this.defaultCascadeTypes.add(CascadeType.PERSIST);
            }
            if (StringHelper.isNotEmpty(defaults.getDefaultCascade())) {
                String[] actions = StringHelper.splitTrimmingTokens(",", defaults.getDefaultCascade(), false);
                assert (actions.length > 0);
                for (int i = 0; i < actions.length; ++i) {
                    this.defaultCascadeTypes.add(CascadeType.valueOf(actions[i]));
                }
            }
        }
    }
}

