/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.TransactSQLStrFunction;
import org.hibernate.dialect.identity.AbstractTransactSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.dialect.temptable.TransactSQLLocalTemporaryTableStrategy;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.internal.NonLockingClauseStrategy;
import org.hibernate.sql.ast.spi.LockingClauseStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public abstract class AbstractTransactSQLDialect
extends Dialect {
    public AbstractTransactSQLDialect(DatabaseVersion version) {
        super(version);
    }

    public AbstractTransactSQLDialect(DialectResolutionInfo info) {
        super(info);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 16 -> "bit";
            case -6 -> "smallint";
            case 4 -> "int";
            case 91, 92, 93, 2013, 2014 -> "datetime";
            case 2004 -> "image";
            case 2005 -> "text";
            case 2011 -> "ntext";
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 0;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.cot();
        functionFactory.ln_log();
        functionFactory.log_loglog();
        functionFactory.log10();
        functionFactory.atan2_atn2();
        functionFactory.mod_operator();
        functionFactory.square();
        functionFactory.rand();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.pi();
        functionFactory.reverse();
        functionFactory.space();
        functionFactory.pad_replicate();
        functionFactory.yearMonthDay();
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.trim1();
        functionFactory.repeat_replicate();
        functionFactory.characterLength_len();
        functionFactory.substring_substringLen();
        functionFactory.datepartDatename();
        functionFactory.lastDay_eomonth();
        functionFactory.bitandorxornot_operator();
        functionContributions.getFunctionRegistry().register("least", new CaseLeastGreatestEmulation(true));
        functionContributions.getFunctionRegistry().register("greatest", new CaseLeastGreatestEmulation(false));
        functionContributions.getFunctionRegistry().register("str", new TransactSQLStrFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("concat", new CastingConcatFunction(this, "+", false, SqlAstNodeRenderingMode.DEFAULT, functionContributions.getTypeConfiguration()));
    }

    @Override
    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim(specification, isWhitespace);
    }

    public static String replaceLtrimRtrim(TrimSpec specification, boolean isWhitespace) {
        return switch (specification) {
            case TrimSpec.LEADING -> {
                if (isWhitespace) {
                    yield "ltrim(?1)";
                }
                yield "substring(?1,patindex('%[^'+?2+']%',?1),len(?1+'x')-1-patindex('%[^'+?2+']%',?1)+1)";
            }
            case TrimSpec.TRAILING -> {
                if (isWhitespace) {
                    yield "rtrim(?1)";
                }
                yield "substring(?1,1,len(?1+'x')-1-patindex('%[^'+?2+']%',reverse(?1))+1)";
            }
            default -> isWhitespace ? "ltrim(rtrim(?1))" : "substring(?1,patindex('%[^'+?2+']%',?1),len(?1+'x')-1-patindex('%[^'+?2+']%',?1)-patindex('%[^'+?2+']%',reverse(?1))+2)";
        };
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public LockingClauseStrategy getLockingClauseStrategy(QuerySpec querySpec, LockOptions lockOptions) {
        return NonLockingClauseStrategy.NON_CLAUSE_STRATEGY;
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return lockOptions.getLockMode().greaterThan(LockMode.READ) ? tableName + " holdlock" : tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions lockOptions, Map<String, String[]> keyColumnNameMap) {
        if (lockOptions.getLockMode() == LockMode.NONE || keyColumnNameMap == null) {
            return sql;
        }
        StringBuilder buffer = new StringBuilder(sql);
        keyColumnNameMap.forEach((tableAlias, keyColumnNames) -> {
            int start = -1;
            int end = -1;
            if (sql.endsWith(" " + tableAlias)) {
                start = buffer.length() - tableAlias.length();
                end = start + tableAlias.length();
            } else {
                int position = buffer.indexOf(" " + tableAlias + " ");
                if (position <= -1) {
                    position = buffer.indexOf(" " + tableAlias + ",");
                }
                if (position > -1) {
                    start = position + 1;
                    end = start + tableAlias.length();
                }
            }
            if (start > -1) {
                String lockHint = this.appendLockHint(lockOptions, (String)tableAlias);
                buffer.replace(start, end, lockHint);
            }
        });
        return buffer.toString();
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select getdate()";
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public boolean requiresCastForConcatenatingNonStrings() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public TemporaryTableStrategy getLocalTemporaryTableStrategy() {
        return TransactSQLLocalTemporaryTableStrategy.INSTANCE;
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return TransactSQLLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableCreateCommand();
    }

    @Override
    public AfterUseAction getTemporaryTableAfterUseAction() {
        return TransactSQLLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableAfterUseAction();
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return TransactSQLLocalTemporaryTableStrategy.INSTANCE.getTemporaryTableBeforeUseAction();
    }

    @Override
    public String getSelectGUIDString() {
        return "select newid()";
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return AbstractTransactSQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("0x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
    }
}

