/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayViaElementArgumentReturnTypeResolver
implements FunctionReturnTypeResolver {
    public static final FunctionReturnTypeResolver DEFAULT_INSTANCE = new ArrayViaElementArgumentReturnTypeResolver(false, 0);
    public static final FunctionReturnTypeResolver DEFAULT_LIST_INSTANCE = new ArrayViaElementArgumentReturnTypeResolver(true, 0);
    public static final FunctionReturnTypeResolver VARARGS_INSTANCE = new ArrayViaElementArgumentReturnTypeResolver(false, -1);
    public static final FunctionReturnTypeResolver VARARGS_LIST_INSTANCE = new ArrayViaElementArgumentReturnTypeResolver(true, -1);
    private final boolean list;
    private final int elementIndex;

    private ArrayViaElementArgumentReturnTypeResolver(boolean list, int elementIndex) {
        this.list = list;
        this.elementIndex = elementIndex;
    }

    @Override
    public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, @Nullable SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        MappingModelExpressible<?> inferredType;
        MappingModelExpressible<?> mappingModelExpressible = inferredType = converter == null ? null : converter.resolveFunctionImpliedReturnType();
        if (inferredType != null) {
            if (inferredType instanceof ReturnableType) {
                ReturnableType returnableType = (ReturnableType)((Object)inferredType);
                return returnableType;
            }
            if (inferredType instanceof BasicValuedMapping) {
                BasicValuedMapping basicValuedMapping = (BasicValuedMapping)inferredType;
                return (ReturnableType)((Object)basicValuedMapping.getJdbcMapping());
            }
        }
        if (impliedType != null) {
            return impliedType;
        }
        if (this.elementIndex == -1) {
            for (SqmTypedNode<?> argument : arguments) {
                SqmDomainType sqmType = argument.getExpressible().getSqmType();
                if (!(sqmType instanceof ReturnableType)) continue;
                return this.list ? DdlTypeHelper.resolveListType(sqmType, typeConfiguration) : DdlTypeHelper.resolveArrayType(sqmType, typeConfiguration);
            }
        } else {
            SqmDomainType sqmType = arguments.get(this.elementIndex).getExpressible().getSqmType();
            if (sqmType instanceof ReturnableType) {
                return this.list ? DdlTypeHelper.resolveListType(sqmType, typeConfiguration) : DdlTypeHelper.resolveArrayType(sqmType, typeConfiguration);
            }
        }
        return null;
    }

    @Override
    public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
        return null;
    }
}

