/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import java.util.Objects;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BindingContext;

public class ArraysOfSameTypeArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator INSTANCE = new ArraysOfSameTypeArgumentValidator();

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        BasicPluralType arrayType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            SqmDomainType sqmType;
            SqmBindableType<?> expressible = arguments.get(i).getExpressible();
            if (expressible == null || (sqmType = expressible.getSqmType()) == null) continue;
            if (arrayType == null) {
                if (!(sqmType instanceof BasicPluralType)) {
                    throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires an array type, but argument is of type '%s'", i, functionName, sqmType.getTypeName()));
                }
                arrayType = (BasicPluralType)sqmType;
                continue;
            }
            if (ArraysOfSameTypeArgumentValidator.isCompatible(arrayType, sqmType)) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires an array type %s, but argument is of type '%s'", i, functionName, arrayType.getTypeName(), sqmType.getTypeName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCompatible(BasicPluralType<?, ?> arrayType, DomainType<?> sqmType) {
        if (arrayType == sqmType) return true;
        if (!(sqmType instanceof BasicPluralType)) return false;
        BasicPluralType basicPluralType = (BasicPluralType)sqmType;
        if (!Objects.equals(arrayType.getElementType(), basicPluralType.getElementType())) return false;
        return true;
    }

    @Override
    public String getSignature() {
        return "(ARRAY array0, ARRAY array1[, ARRAY array2, ...])";
    }
}

