/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.ParameterizedTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class DdlTypeHelper {
    @AllowReflection
    public static BasicType<?> resolveArrayType(DomainType<?> elementType, TypeConfiguration typeConfiguration) {
        BasicPluralJavaType arrayJavaType = (BasicPluralJavaType)((Object)typeConfiguration.getJavaTypeRegistry().getDescriptor(Array.newInstance(elementType.getJavaType(), 0).getClass()));
        Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        return arrayJavaType.resolveType(typeConfiguration, dialect, (BasicType)elementType, null, typeConfiguration.getCurrentBaseSqlTypeIndicators());
    }

    public static BasicType<?> resolveListType(DomainType<?> elementType, TypeConfiguration typeConfiguration) {
        BasicPluralJavaType arrayJavaType = (BasicPluralJavaType)((Object)typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)List.class)).createJavaType(new ParameterizedTypeImpl((Type)((Object)List.class), new Type[]{elementType.getJavaType()}, null), typeConfiguration));
        Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        return arrayJavaType.resolveType(typeConfiguration, dialect, (BasicType)elementType, null, typeConfiguration.getCurrentBaseSqlTypeIndicators());
    }

    public static String getTypeName(BasicType<?> type, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getTypeName(type, typeConfiguration);
    }

    public static String getTypeName(BasicType<?> type, Size size, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getTypeName(type, size, typeConfiguration);
    }

    public static String getTypeName(JdbcMappingContainer type, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getTypeName(type, Size.nil(), typeConfiguration);
    }

    public static String getTypeName(JdbcMappingContainer type, Size size, TypeConfiguration typeConfiguration) {
        if (type instanceof SqlTypedMapping) {
            SqlTypedMapping sqlTypedMapping = (SqlTypedMapping)((Object)type);
            return AbstractSqlAstTranslator.getSqlTypeName(sqlTypedMapping, typeConfiguration);
        }
        BasicType basicType = (BasicType)type.getSingleJdbcMapping();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor(basicType.getJdbcType().getDdlTypeCode());
        return ddlType.getTypeName(size, basicType, ddlTypeRegistry);
    }

    public static String getTypeName(ReturnableType<?> type, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getTypeName(type, Size.nil(), typeConfiguration);
    }

    public static String getTypeName(ReturnableType<?> type, Size size, TypeConfiguration typeConfiguration) {
        if (type instanceof SqlTypedMapping) {
            SqlTypedMapping sqlTypedMapping = (SqlTypedMapping)((Object)type);
            return AbstractSqlAstTranslator.getSqlTypeName(sqlTypedMapping, typeConfiguration);
        }
        BasicType basicType = (BasicType)((JdbcMappingContainer)((Object)type)).getSingleJdbcMapping();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor(basicType.getJdbcType().getDdlTypeCode());
        return ddlType.getTypeName(size, basicType, ddlTypeRegistry);
    }

    public static String getCastTypeName(BasicType<?> type, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getCastTypeName(type, typeConfiguration);
    }

    public static String getCastTypeName(BasicType<?> type, Size size, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getCastTypeName(type, size, typeConfiguration);
    }

    public static String getCastTypeName(JdbcMappingContainer type, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getCastTypeName(type, Size.nil(), typeConfiguration);
    }

    public static String getCastTypeName(JdbcMappingContainer type, Size size, TypeConfiguration typeConfiguration) {
        if (type instanceof SqlTypedMapping) {
            SqlTypedMapping sqlTypedMapping = (SqlTypedMapping)((Object)type);
            return AbstractSqlAstTranslator.getCastTypeName(sqlTypedMapping, typeConfiguration);
        }
        BasicType basicType = (BasicType)type.getSingleJdbcMapping();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor(basicType.getJdbcType().getDdlTypeCode());
        return ddlType.getCastTypeName(size, basicType, ddlTypeRegistry);
    }

    public static String getCastTypeName(ReturnableType<?> type, TypeConfiguration typeConfiguration) {
        return DdlTypeHelper.getCastTypeName(type, Size.nil(), typeConfiguration);
    }

    public static String getCastTypeName(ReturnableType<?> type, Size size, TypeConfiguration typeConfiguration) {
        if (type instanceof SqlTypedMapping) {
            SqlTypedMapping sqlTypedMapping = (SqlTypedMapping)((Object)type);
            return AbstractSqlAstTranslator.getCastTypeName(sqlTypedMapping, typeConfiguration);
        }
        BasicType basicType = (BasicType)((JdbcMappingContainer)((Object)type)).getSingleJdbcMapping();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor(basicType.getJdbcType().getDdlTypeCode());
        return ddlType.getCastTypeName(size, basicType, ddlTypeRegistry);
    }
}

