/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConstructorFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicPluralType;

public class OracleArrayConstructorFunction
extends ArrayConstructorFunction {
    public OracleArrayConstructorFunction(boolean list) {
        super(list, false);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (returnType == null) {
            throw new SemanticException("Oracle array constructor emulation requires knowledge about the return type, but resolved return type could not be determined");
        }
        if (!(returnType instanceof BasicPluralType)) {
            throw new SemanticException("Oracle array constructor emulation requires a basic plural return type, but resolved return type was: " + String.valueOf(returnType));
        }
        BasicPluralType pluralType = (BasicPluralType)returnType;
        String arrayTypeName = DdlTypeHelper.getCastTypeName(pluralType, walker.getSessionFactory().getTypeConfiguration());
        sqlAppender.appendSql(arrayTypeName);
        int size = sqlAstArguments.size();
        if (size == 0) {
            sqlAppender.append('(');
        } else {
            int separator = 40;
            for (int i = 0; i < size; ++i) {
                SqlAstNode argument = sqlAstArguments.get(i);
                sqlAppender.append((char)separator);
                argument.accept(walker);
                separator = 44;
            }
        }
        sqlAppender.append(')');
    }
}

