/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.H2JsonValueFunction;
import org.hibernate.dialect.function.json.JsonTableFunction;
import org.hibernate.dialect.function.json.JsonTableSetReturningFunctionTypeResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonTableFunction;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableNestedColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableValueColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.PredicateContainer;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class H2JsonTableFunction
extends JsonTableFunction {
    private final int maximumArraySize;

    public H2JsonTableFunction(int maximumArraySize, TypeConfiguration typeConfiguration) {
        super(new H2JsonTableSetReturningFunctionTypeResolver(), typeConfiguration);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> sqmArguments, QueryEngine queryEngine) {
        return new SqmJsonTableFunction<T>(this, this, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), (SqmExpression)sqmArguments.get(0), sqmArguments.size() > 1 ? (SqmExpression)sqmArguments.get(1) : null){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                JsonTableFunction.JsonTableArguments arguments = JsonTableFunction.JsonTableArguments.extract(functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments());
                walker.registerQueryTransformer(new JsonTableQueryTransformer(functionTableGroup, arguments, H2JsonTableFunction.this.maximumArraySize));
                return functionTableGroup;
            }
        };
    }

    @Override
    public boolean rendersIdentifierVariable(List<SqlAstNode> arguments, SessionFactoryImplementor sessionFactory) {
        return true;
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, JsonTableFunction.JsonTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() == JsonTableErrorBehavior.NULL) {
            throw new QueryException("Can't emulate null on error clause on H2");
        }
        Expression jsonPathExpression = arguments.jsonPath();
        boolean isArray = H2JsonTableFunction.isArrayAccess(jsonPathExpression, walker);
        if (arguments.jsonDocument().getColumnReference() == null) {
            sqlAppender.append('(');
        }
        if (isArray) {
            sqlAppender.append("system_range(1,");
            sqlAppender.append(Integer.toString(this.maximumArraySize));
            sqlAppender.append(") ");
        } else {
            sqlAppender.append("system_range(1,1) ");
        }
        sqlAppender.append(tableIdentifierVariable);
        if (arguments.jsonDocument().getColumnReference() == null) {
            sqlAppender.append(" join (values (");
            arguments.jsonDocument().accept(walker);
            if (!arguments.isJsonType()) {
                sqlAppender.append(" format json");
            }
            sqlAppender.append(")) ");
            sqlAppender.append(tableIdentifierVariable);
            sqlAppender.append("_(d) on 1=1)");
        }
    }

    private static boolean isArrayAccess(@Nullable Expression jsonPath, SqlAstTranslator<?> walker) {
        if (jsonPath != null) {
            try {
                return H2JsonTableFunction.isArrayAccess((String)walker.getLiteralValue(jsonPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean isArrayAccess(String jsonPath) {
        return jsonPath.endsWith("[*]");
    }

    private static int getLastArrayIndex(JsonTableColumnsClause jsonTableColumnsClause, int arrayIndex) {
        int currentArrayIndex = arrayIndex;
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            if (!(columnDefinition instanceof JsonTableNestedColumnDefinition)) continue;
            JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
            currentArrayIndex = H2JsonTableFunction.getLastArrayIndex(nestedColumnDefinition.columns(), arrayIndex + (H2JsonTableFunction.isArrayAccess(nestedColumnDefinition.jsonPath()) ? 1 : 0));
        }
        return currentArrayIndex;
    }

    private static String ordinalityExpression(String tableIdentifierVariable, int clauseLevel) {
        if (clauseLevel == 0) {
            return tableIdentifierVariable + ".x";
        }
        return tableIdentifierVariable + "_" + clauseLevel + "_.x";
    }

    private static class H2JsonTableSetReturningFunctionTypeResolver
    extends JsonTableSetReturningFunctionTypeResolver {
        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> sqlAstNodes, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            Object parentPath;
            boolean isArray;
            JsonTableFunction.JsonTableArguments arguments = JsonTableFunction.JsonTableArguments.extract(sqlAstNodes);
            Expression jsonDocument = arguments.jsonDocument();
            ColumnReference columnReference = jsonDocument.getColumnReference();
            Object documentPath = columnReference != null ? columnReference.getExpressionText() : tableIdentifierVariable + "_.d";
            if (arguments.jsonPath() != null) {
                Expression expression = arguments.jsonPath();
                if (!(expression instanceof Literal)) {
                    throw new QueryException("H2 json_table() only supports literal json paths, but got " + String.valueOf(arguments.jsonPath()));
                }
                Literal literal = (Literal)expression;
                String rawJsonPath = (String)literal.getLiteralValue();
                isArray = H2JsonTableFunction.isArrayAccess(rawJsonPath);
                String jsonPath = isArray ? rawJsonPath.substring(0, rawJsonPath.length() - 3) : rawJsonPath;
                parentPath = H2JsonValueFunction.applyJsonPath((String)documentPath, true, arguments.isJsonType(), jsonPath, arguments.passingClause());
            } else {
                isArray = true;
                parentPath = documentPath;
            }
            String parentReadExpression = isArray ? "array_get(" + (String)parentPath + "," + tableIdentifierVariable + ".x)" : "(" + (String)parentPath + ")";
            List<JsonTableColumnDefinition> columnDefinitions = arguments.columnsClause().getColumnDefinitions();
            ArrayList<SelectableMapping> selectableMappings = new ArrayList<SelectableMapping>(columnDefinitions.size());
            this.addSelectableMappings(selectableMappings, tableIdentifierVariable, arguments.columnsClause(), 0, parentReadExpression, converter);
            return selectableMappings.toArray(new SelectableMapping[0]);
        }

        protected int addSelectableMappings(List<SelectableMapping> selectableMappings, String tableIdentifierVariable, JsonTableColumnsClause columnsClause, int clauseLevel, String parentReadExpression, SqmToSqlAstConverter converter) {
            int currentClauseLevel = clauseLevel;
            for (JsonTableColumnDefinition columnDefinition : columnsClause.getColumnDefinitions()) {
                if (columnDefinition instanceof JsonTableExistsColumnDefinition) {
                    JsonTableExistsColumnDefinition definition = (JsonTableExistsColumnDefinition)columnDefinition;
                    this.addSelectableMappings(selectableMappings, definition, parentReadExpression, converter);
                    continue;
                }
                if (columnDefinition instanceof JsonTableQueryColumnDefinition) {
                    JsonTableQueryColumnDefinition definition = (JsonTableQueryColumnDefinition)columnDefinition;
                    this.addSelectableMappings(selectableMappings, definition, parentReadExpression, converter);
                    continue;
                }
                if (columnDefinition instanceof JsonTableValueColumnDefinition) {
                    JsonTableValueColumnDefinition definition = (JsonTableValueColumnDefinition)columnDefinition;
                    this.addSelectableMappings(selectableMappings, definition, parentReadExpression, converter);
                    continue;
                }
                if (columnDefinition instanceof JsonTableOrdinalityColumnDefinition) {
                    JsonTableOrdinalityColumnDefinition definition = (JsonTableOrdinalityColumnDefinition)columnDefinition;
                    this.addSelectableMappings(selectableMappings, tableIdentifierVariable, definition, clauseLevel, converter);
                    continue;
                }
                JsonTableNestedColumnDefinition definition = (JsonTableNestedColumnDefinition)columnDefinition;
                currentClauseLevel = this.addSelectableMappings(selectableMappings, tableIdentifierVariable, definition, currentClauseLevel, parentReadExpression, converter);
            }
            return currentClauseLevel;
        }

        protected int addSelectableMappings(List<SelectableMapping> selectableMappings, String tableIdentifierVariable, JsonTableNestedColumnDefinition columnDefinition, int clauseLevel, String parentReadExpression, SqmToSqlAstConverter converter) {
            Object readExpression;
            int nextClauseLevel;
            String rawJsonPath = columnDefinition.jsonPath();
            boolean isArray = H2JsonTableFunction.isArrayAccess(rawJsonPath);
            String jsonPath = isArray ? rawJsonPath.substring(0, rawJsonPath.length() - 3) : rawJsonPath;
            String parentPath = H2JsonValueFunction.applyJsonPath(parentReadExpression, false, true, jsonPath, null);
            if (isArray) {
                nextClauseLevel = clauseLevel + 1;
                readExpression = "array_get(" + parentPath + "," + H2JsonTableFunction.ordinalityExpression(tableIdentifierVariable, nextClauseLevel) + ")";
            } else {
                nextClauseLevel = clauseLevel;
                readExpression = parentPath;
            }
            return this.addSelectableMappings(selectableMappings, tableIdentifierVariable, columnDefinition.columns(), nextClauseLevel, (String)readExpression, converter);
        }

        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, String tableIdentifierVariable, JsonTableOrdinalityColumnDefinition definition, int clauseLevel, SqmToSqlAstConverter converter) {
            this.addSelectableMapping(selectableMappings, definition.name(), H2JsonTableFunction.ordinalityExpression(tableIdentifierVariable, clauseLevel), converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class));
        }

        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableValueColumnDefinition definition, String parentReadExpression, SqmToSqlAstConverter converter) {
            Literal defaultExpression;
            JsonValueEmptyBehavior emptyBehavior = definition.emptyBehavior();
            if (emptyBehavior != null && emptyBehavior.getDefaultExpression() != null) {
                Expression expression = emptyBehavior.getDefaultExpression();
                if (!(expression instanceof Literal)) {
                    throw new QueryException("H2 json_table() only supports literal default expressions, but got " + String.valueOf(emptyBehavior.getDefaultExpression()));
                }
                Literal literal = (Literal)expression;
                defaultExpression = literal;
            } else {
                defaultExpression = null;
            }
            String baseReadExpression = this.determineElementReadExpression(definition.name(), definition.jsonPath(), parentReadExpression);
            String elementReadExpression = this.castValueExpression(baseReadExpression, definition.type(), defaultExpression, converter);
            this.addSelectableMapping(selectableMappings, definition.name(), elementReadExpression, definition.type().getJdbcMapping());
        }

        private String castValueExpression(String baseReadExpression, CastTarget castTarget, @Nullable Literal defaultExpression, SqmToSqlAstConverter converter) {
            StringBuilder sb = new StringBuilder(baseReadExpression.length() + 200);
            if (defaultExpression != null) {
                sb.append("coalesce(");
            }
            boolean hexDecoding = H2JsonValueFunction.needsHexDecoding(castTarget.getJdbcMapping());
            sb.append("cast(");
            if (hexDecoding) {
                sb.append("hextoraw(regexp_replace(");
            }
            sb.append("stringdecode(regexp_replace(nullif(");
            sb.append(baseReadExpression);
            sb.append(",JSON'null'),'^\"(.*)\"$','$1'))");
            if (hexDecoding) {
                sb.append(",'([0-9a-f][0-9a-f])','00$1'))");
            }
            sb.append(" as ");
            sb.append(JsonTableFunction.determineColumnType(castTarget, converter.getCreationContext().getTypeConfiguration()));
            sb.append(')');
            if (defaultExpression != null) {
                sb.append(',');
                String sqlLiteral = defaultExpression.getJdbcMapping().getJdbcLiteralFormatter().toJdbcLiteral(defaultExpression.getLiteralValue(), converter.getCreationContext().getDialect(), converter.getCreationContext().getWrapperOptions());
                sb.append(sqlLiteral);
                sb.append(')');
            }
            return sb.toString();
        }

        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableQueryColumnDefinition definition, String parentReadExpression, SqmToSqlAstConverter converter) {
            String baseReadExpression = this.determineElementReadExpression(definition.name(), definition.jsonPath(), parentReadExpression);
            String elementReadExpression = this.castQueryExpression(baseReadExpression, definition.emptyBehavior(), definition.wrapMode(), converter);
            this.addSelectableMapping(selectableMappings, definition.name(), elementReadExpression, converter.getCreationContext().getTypeConfiguration().getBasicTypeRegistry().resolve(String.class, 3001));
        }

        private String castQueryExpression(String baseReadExpression, JsonQueryEmptyBehavior emptyBehavior, JsonQueryWrapMode wrapMode, SqmToSqlAstConverter converter) {
            StringBuilder sb = new StringBuilder(baseReadExpression.length() + 200);
            if (emptyBehavior == JsonQueryEmptyBehavior.EMPTY_ARRAY || emptyBehavior == JsonQueryEmptyBehavior.EMPTY_OBJECT) {
                sb.append("coalesce(");
            }
            if (wrapMode == JsonQueryWrapMode.WITH_WRAPPER) {
                sb.append("'['||");
            }
            sb.append("stringdecode(regexp_replace(nullif(");
            sb.append(baseReadExpression);
            sb.append(",JSON'null'),'^\"(.*)\"$','$1'))");
            if (wrapMode == JsonQueryWrapMode.WITH_WRAPPER) {
                sb.append("||']'");
            }
            if (emptyBehavior == JsonQueryEmptyBehavior.EMPTY_ARRAY) {
                sb.append(",'[]')");
            } else if (emptyBehavior == JsonQueryEmptyBehavior.EMPTY_OBJECT) {
                sb.append(",'{}')");
            }
            return sb.toString();
        }

        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableExistsColumnDefinition definition, String parentReadExpression, SqmToSqlAstConverter converter) {
            String baseReadExpression = this.determineElementReadExpression(definition.name(), definition.jsonPath(), parentReadExpression);
            String elementReadExpression = parentReadExpression + " is not null and " + baseReadExpression + " is not null";
            this.addSelectableMapping(selectableMappings, definition.name(), elementReadExpression, converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Boolean.class));
        }

        protected String determineElementReadExpression(String name, @Nullable String jsonPath, String parentReadExpression) {
            return jsonPath == null ? H2JsonValueFunction.applyJsonPath(parentReadExpression, false, true, "$." + name, null) : H2JsonValueFunction.applyJsonPath(parentReadExpression, false, true, jsonPath, null);
        }

        protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, String elementReadExpression, JdbcMapping type) {
            selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), elementReadExpression, null, null, null, null, null, null, false, false, false, false, false, false, type));
        }
    }

    private static class ArrayLengthExpression
    implements SelfRenderingExpression {
        private final Expression arrayExpression;
        private final BasicType<Integer> integerType;

        public ArrayLengthExpression(Expression arrayExpression, BasicType<Integer> integerType) {
            this.arrayExpression = arrayExpression;
            this.integerType = integerType;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.append("coalesce(array_length(");
            this.arrayExpression.accept(walker);
            sqlAppender.append("),0)");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.integerType;
        }
    }

    private static class ArrayAccessExpression
    implements SelfRenderingExpression {
        private final Expression array;
        private final String indexFragment;

        public ArrayAccessExpression(Expression array, String indexFragment) {
            this.array = array;
            this.indexFragment = indexFragment;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql("array_get(");
            this.array.accept(walker);
            sqlAppender.appendSql(',');
            sqlAppender.appendSql(this.indexFragment);
            sqlAppender.appendSql(')');
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return null;
        }
    }

    private static class JsonValueExpression
    implements SelfRenderingExpression {
        private final Expression jsonDocument;
        private final boolean isJsonType;
        private final String jsonPath;
        private final @Nullable JsonPathPassingClause passingClause;

        public JsonValueExpression(Expression jsonDocument, String jsonPath, @Nullable JsonPathPassingClause passingClause) {
            this.jsonDocument = jsonDocument;
            this.isJsonType = jsonDocument instanceof JsonValueExpression || jsonDocument instanceof ArrayAccessExpression;
            this.jsonPath = jsonPath;
            this.passingClause = passingClause;
        }

        public JsonValueExpression(Expression jsonDocument, boolean isJsonType, String jsonPath, @Nullable JsonPathPassingClause passingClause) {
            this.jsonDocument = jsonDocument;
            this.isJsonType = isJsonType;
            this.jsonPath = jsonPath;
            this.passingClause = passingClause;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            H2JsonValueFunction.renderJsonPath(sqlAppender, this.jsonDocument, this.isJsonType, walker, this.jsonPath, this.passingClause);
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return null;
        }
    }

    private static class JsonTableQueryTransformer
    implements QueryTransformer {
        private final FunctionTableGroup functionTableGroup;
        private final JsonTableFunction.JsonTableArguments arguments;
        private final int maximumArraySize;

        public JsonTableQueryTransformer(FunctionTableGroup functionTableGroup, JsonTableFunction.JsonTableArguments arguments, int maximumArraySize) {
            this.functionTableGroup = functionTableGroup;
            this.arguments = arguments;
            this.maximumArraySize = maximumArraySize;
        }

        @Override
        public QuerySpec transform(CteContainer cteContainer, QuerySpec querySpec, SqmToSqlAstConverter converter) {
            int lastArrayIndex;
            boolean isArray;
            if (this.arguments.jsonPath() != null) {
                Expression expression = this.arguments.jsonPath();
                if (!(expression instanceof Literal)) {
                    throw new QueryException("H2 json_table() only supports literal json paths, but got " + String.valueOf(this.arguments.jsonPath()));
                }
                Literal literal = (Literal)expression;
                String rawJsonPath = (String)literal.getLiteralValue();
                isArray = H2JsonTableFunction.isArrayAccess(rawJsonPath);
            } else {
                isArray = true;
            }
            if (isArray) {
                TableGroup parentTableGroup = querySpec.getFromClause().queryTableGroups(tg -> tg.findTableGroupJoin(this.functionTableGroup) == null ? null : tg);
                PredicateContainer predicateContainer = parentTableGroup != null ? parentTableGroup.findTableGroupJoin(this.functionTableGroup) : querySpec;
                BasicType<Integer> integerType = converter.getSqmCreationContext().getNodeBuilder().getIntegerType();
                Expression jsonDocument = this.arguments.jsonDocument().getColumnReference() == null ? new ColumnReference(this.functionTableGroup.getPrimaryTableReference().getIdentificationVariable() + "_", "d", false, null, this.arguments.jsonDocument().getExpressionType().getSingleJdbcMapping()) : this.arguments.jsonDocument();
                ArrayLengthExpression lhs = new ArrayLengthExpression(jsonDocument, integerType);
                ColumnReference rhs = new ColumnReference(this.functionTableGroup.getPrimaryTableReference().getIdentificationVariable(), "x", false, null, integerType);
                predicateContainer.applyPredicate(new ComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN_OR_EQUAL, rhs));
            }
            if ((lastArrayIndex = H2JsonTableFunction.getLastArrayIndex(this.arguments.columnsClause(), 0)) != 0) {
                String tableIdentifierVariable = this.functionTableGroup.getPrimaryTableReference().getIdentificationVariable();
                Expression jsonDocument = this.arguments.jsonDocument().getColumnReference() == null ? new ColumnReference(tableIdentifierVariable + "_", "d", false, null, this.arguments.jsonDocument().getExpressionType().getSingleJdbcMapping()) : this.arguments.jsonDocument();
                FunctionTableGroup tableGroup = new FunctionTableGroup(this.functionTableGroup.getNavigablePath().append("{synthetic}"), null, new SelfRenderingFunctionSqlAstExpression("json_table_emulation", new NestedPathFunctionRenderer(tableIdentifierVariable, this.arguments, jsonDocument, this.maximumArraySize, lastArrayIndex), Collections.emptyList(), null, null), tableIdentifierVariable + "_synthetic_", Collections.emptyList(), Set.of(""), false, false, true, converter.getCreationContext().getSessionFactory());
                BasicType<Integer> integerType = converter.getSqmCreationContext().getNodeBuilder().getIntegerType();
                ArrayLengthExpression lhs = new ArrayLengthExpression(JsonTableQueryTransformer.determineLastArrayExpression(tableIdentifierVariable, this.arguments, jsonDocument), integerType);
                ColumnReference rhs = new ColumnReference(tableIdentifierVariable + "_" + lastArrayIndex + "_", "x", false, null, integerType);
                ComparisonPredicate predicate = new ComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN_OR_EQUAL, rhs);
                this.functionTableGroup.addTableGroupJoin(new TableGroupJoin(tableGroup.getNavigablePath(), SqlAstJoinType.LEFT, tableGroup, predicate));
            }
            return querySpec;
        }

        private static Expression determineLastArrayExpression(String tableIdentifierVariable, JsonTableFunction.JsonTableArguments arguments, Expression jsonDocument) {
            ArrayExpressionEntry arrayExpressionEntry = JsonTableQueryTransformer.determineLastArrayExpression(tableIdentifierVariable, JsonTableQueryTransformer.determineJsonElement(tableIdentifierVariable, arguments, jsonDocument), arguments.columnsClause(), new ArrayExpressionEntry(0, null));
            return NullnessUtil.castNonNull(arrayExpressionEntry.expression());
        }

        private static ArrayExpressionEntry determineLastArrayExpression(String tableIdentifierVariable, Expression parentJson, JsonTableColumnsClause jsonTableColumnsClause, ArrayExpressionEntry parentEntry) {
            ArrayExpressionEntry currentArrayEntry = parentEntry;
            for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
                ArrayExpressionEntry nextArrayExpression;
                SelfRenderingExpression jsonElement;
                if (!(columnDefinition instanceof JsonTableNestedColumnDefinition)) continue;
                JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
                String rawJsonPath = nestedColumnDefinition.jsonPath();
                boolean isArray = H2JsonTableFunction.isArrayAccess(rawJsonPath);
                String jsonPath = isArray ? rawJsonPath.substring(0, rawJsonPath.length() - 3) : rawJsonPath;
                JsonValueExpression jsonQueryResult = new JsonValueExpression(parentJson, jsonPath, null);
                if (isArray) {
                    int nextArrayIndex = currentArrayEntry.arrayIndex() + 1;
                    jsonElement = new ArrayAccessExpression(jsonQueryResult, H2JsonTableFunction.ordinalityExpression(tableIdentifierVariable, nextArrayIndex));
                    nextArrayExpression = new ArrayExpressionEntry(nextArrayIndex, jsonQueryResult);
                } else {
                    jsonElement = jsonQueryResult;
                    nextArrayExpression = currentArrayEntry;
                }
                currentArrayEntry = JsonTableQueryTransformer.determineLastArrayExpression(tableIdentifierVariable, jsonElement, nestedColumnDefinition.columns(), nextArrayExpression);
            }
            return currentArrayEntry;
        }

        private static Expression determineJsonElement(String tableIdentifierVariable, JsonTableFunction.JsonTableArguments arguments, Expression jsonDocument) {
            Expression jsonQueryResult;
            boolean isArray;
            if (arguments.jsonPath() != null) {
                Expression expression = arguments.jsonPath();
                if (!(expression instanceof Literal)) {
                    throw new QueryException("H2 json_table() only supports literal json paths, but got " + String.valueOf(arguments.jsonPath()));
                }
                Literal literal = (Literal)expression;
                String rawJsonPath = (String)literal.getLiteralValue();
                isArray = H2JsonTableFunction.isArrayAccess(rawJsonPath);
                String jsonPath = isArray ? rawJsonPath.substring(0, rawJsonPath.length() - 3) : rawJsonPath;
                jsonQueryResult = "$".equals(jsonPath) ? jsonDocument : new JsonValueExpression(jsonDocument, arguments.isJsonType(), jsonPath, arguments.passingClause());
            } else {
                isArray = true;
                jsonQueryResult = jsonDocument;
            }
            Expression jsonElement = isArray ? new ArrayAccessExpression(jsonQueryResult, tableIdentifierVariable + ".x") : jsonQueryResult;
            return jsonElement;
        }

        private static class NestedPathFunctionRenderer
        implements FunctionRenderer {
            private final String tableIdentifierVariable;
            private final JsonTableFunction.JsonTableArguments arguments;
            private final Expression jsonDocument;
            private final int maximumArraySize;
            private final int lastArrayIndex;

            public NestedPathFunctionRenderer(String tableIdentifierVariable, JsonTableFunction.JsonTableArguments arguments, Expression jsonDocument, int maximumArraySize, int lastArrayIndex) {
                this.tableIdentifierVariable = tableIdentifierVariable;
                this.arguments = arguments;
                this.jsonDocument = jsonDocument;
                this.maximumArraySize = maximumArraySize;
                this.lastArrayIndex = lastArrayIndex;
            }

            @Override
            public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
                Expression jsonElement = JsonTableQueryTransformer.determineJsonElement(this.tableIdentifierVariable, this.arguments, this.jsonDocument);
                this.renderNestedColumnJoins(sqlAppender, this.tableIdentifierVariable, jsonElement, this.arguments.columnsClause(), 0, this.lastArrayIndex, walker);
            }

            private int renderNestedColumnJoins(SqlAppender sqlAppender, String tableIdentifierVariable, Expression parentJson, JsonTableColumnsClause jsonTableColumnsClause, int arrayIndex, int lastArrayIndex, SqlAstTranslator<?> walker) {
                int currentArrayIndex = arrayIndex;
                for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
                    SelfRenderingExpression jsonElement;
                    if (!(columnDefinition instanceof JsonTableNestedColumnDefinition)) continue;
                    JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
                    String rawJsonPath = nestedColumnDefinition.jsonPath();
                    boolean isArray = H2JsonTableFunction.isArrayAccess(rawJsonPath);
                    String jsonPath = isArray ? rawJsonPath.substring(0, rawJsonPath.length() - 3) : rawJsonPath;
                    int nextArrayIndex = currentArrayIndex + (isArray ? 1 : 0);
                    if (isArray && currentArrayIndex != 0) {
                        sqlAppender.appendSql(" left join ");
                    }
                    JsonValueExpression jsonQueryResult = new JsonValueExpression(parentJson, jsonPath, null);
                    if (isArray) {
                        sqlAppender.append("system_range(1,");
                        sqlAppender.append(Integer.toString(this.maximumArraySize));
                        sqlAppender.append(") ");
                        sqlAppender.appendSql(tableIdentifierVariable);
                        sqlAppender.appendSql('_');
                        sqlAppender.appendSql(nextArrayIndex);
                        sqlAppender.appendSql('_');
                        String ordinalityExpression = H2JsonTableFunction.ordinalityExpression(tableIdentifierVariable, nextArrayIndex);
                        if (nextArrayIndex != lastArrayIndex) {
                            sqlAppender.appendSql(" on coalesce(array_length(");
                            jsonQueryResult.accept(walker);
                            sqlAppender.append("),0)>=");
                            sqlAppender.appendSql(ordinalityExpression);
                        }
                        jsonElement = new ArrayAccessExpression(jsonQueryResult, ordinalityExpression);
                    } else {
                        jsonElement = jsonQueryResult;
                    }
                    currentArrayIndex = this.renderNestedColumnJoins(sqlAppender, tableIdentifierVariable, jsonElement, nestedColumnDefinition.columns(), nextArrayIndex, lastArrayIndex, walker);
                }
                return currentArrayIndex;
            }
        }

        record ArrayExpressionEntry(int arrayIndex, @Nullable Expression expression) {
        }
    }
}

