/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.dialect.HANADialect;
import org.hibernate.dialect.sql.ast.SybaseASESqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class HANASqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean inLateral;

    public HANASqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql("cast(");
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(" as int)");
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    @Override
    protected void visitArithmeticOperand(Expression expression) {
        this.render(expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }

    private boolean isHanaCloud() {
        return ((HANADialect)this.getDialect()).isCloud();
    }

    @Override
    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (this.isHanaCloud() && HANASqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.visitUpdateStatementEmulateMerge(statement);
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }

    @Override
    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (this.isHanaCloud()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update");
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.UPDATE);
                this.renderTableReferenceIdentificationVariable(updateStatement.getTargetTable());
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    @Override
    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        if (!this.isHanaCloud()) {
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    protected boolean isCorrelated(CteStatement cteStatement) {
        return false;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        if (tableReference.isLateral() && !this.inLateral) {
            this.inLateral = true;
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
            this.inLateral = false;
        } else {
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
        }
    }

    @Override
    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        if (tableReference instanceof FunctionTableReference && tableReference.isLateral()) {
            tableReference.accept(this);
        } else {
            super.renderDerivedTableReference(tableReference);
        }
    }

    @Override
    public void renderNamedSetReturningFunction(String functionName, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstNodeRenderingMode argumentRenderingMode) {
        ModelPart ordinalitySubPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        if (ordinalitySubPart != null) {
            this.appendSql("(select t.*, row_number() over() ");
            this.appendSql(ordinalitySubPart.asBasicValuedModelPart().getSelectionExpression());
            this.appendSql(" from ");
            this.renderSimpleNamedFunction(functionName, sqlAstArguments, argumentRenderingMode);
            this.append(" t)");
        } else {
            super.renderNamedSetReturningFunction(functionName, sqlAstArguments, tupleType, tableIdentifierVariable, argumentRenderingMode);
        }
    }

    @Override
    protected SqlAstNodeRenderingMode getParameterRenderingMode() {
        return this.inLateral ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : super.getParameterRenderingMode();
    }

    @Override
    protected void renderDerivedTableReferenceIdentificationVariable(DerivedTableReference tableReference) {
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        boolean isLob = SybaseASESqlAstTranslator.isLob(lhs.getExpressionType());
        if (operator == ComparisonOperator.DISTINCT_FROM || operator == ComparisonOperator.NOT_DISTINCT_FROM) {
            if (isLob) {
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("case when ");
                        lhs.accept(this);
                        this.appendSql(" like ");
                        rhs.accept(this);
                        this.appendSql(" or ");
                        lhs.accept(this);
                        this.appendSql(" is null and ");
                        rhs.accept(this);
                        this.appendSql(" is null then 0 else 1 end=1");
                        return;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("case when ");
                        lhs.accept(this);
                        this.appendSql(" like ");
                        rhs.accept(this);
                        this.appendSql(" or ");
                        lhs.accept(this);
                        this.appendSql(" is null and ");
                        rhs.accept(this);
                        this.appendSql(" is null then 0 else 1 end=0");
                        return;
                    }
                }
            }
            this.withParameterRenderingMode(SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, () -> this.renderComparisonEmulateIntersect(lhs, operator, rhs));
        } else {
            if (isLob) {
                switch (operator) {
                    case EQUAL: {
                        lhs.accept(this);
                        this.appendSql(" like ");
                        rhs.accept(this);
                        return;
                    }
                    case NOT_EQUAL: {
                        lhs.accept(this);
                        this.appendSql(" not like ");
                        rhs.accept(this);
                        return;
                    }
                }
            }
            this.renderComparisonStandard(lhs, operator, rhs);
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("grouping sets (())");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        throw new MappingException(String.format("The INSERT statement for table [%s] contains no column, and this is not supported by [%s]", tableInsert.getMutatingTable().getTableId(), this.getDialect()));
    }

    @Override
    protected void visitValuesList(List<Values> valuesList) {
        this.visitValuesListEmulateSelectUnion(valuesList);
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }
}

