/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.internal.UserSuppliedConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.internal.Helper;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class ConnectionProviderInitiator
implements StandardServiceInitiator<ConnectionProvider> {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ConnectionProviderInitiator.class);
    public static final ConnectionProviderInitiator INSTANCE = new ConnectionProviderInitiator();
    public static final String C3P0_STRATEGY = "c3p0";
    public static final String HIKARI_STRATEGY = "hikari";
    public static final String AGROAL_STRATEGY = "agroal";
    private static final Set<String> SPECIAL_PROPERTIES = new HashSet<String>();
    private static final Map<String, Integer> ISOLATION_VALUE_MAP;
    private static final Map<Integer, String> ISOLATION_VALUE_CONSTANT_NAME_MAP;
    private static final Map<Integer, String> ISOLATION_VALUE_NICE_NAME_MAP;
    private static final Map<String, String> CONDITIONAL_PROPERTIES;

    @Override
    public Class<ConnectionProvider> getServiceInitiated() {
        return ConnectionProvider.class;
    }

    @Override
    public ConnectionProvider initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        if (JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            return null;
        }
        BeanContainer beanContainer = Helper.getBeanContainer(registry);
        StrategySelector strategySelector = registry.requireService(StrategySelector.class);
        Object explicitSetting = configurationValues.get("hibernate.connection.provider_class");
        if (explicitSetting != null) {
            if (explicitSetting instanceof ConnectionProvider) {
                ConnectionProvider provider = (ConnectionProvider)explicitSetting;
                return provider;
            }
            if (explicitSetting instanceof Class) {
                Class providerClass = (Class)explicitSetting;
                LOG.instantiatingExplicitConnectionProvider(providerClass.getName());
                return this.instantiateExplicitConnectionProvider(ConnectionProviderInitiator.connectionProviderClass(providerClass), beanContainer);
            }
            String providerName = StringHelper.nullIfBlank(explicitSetting.toString());
            if (providerName != null) {
                return this.instantiateNamedConnectionProvider(providerName, strategySelector, beanContainer);
            }
        }
        return this.instantiateConnectionProvider(configurationValues, strategySelector, beanContainer);
    }

    private static Class<? extends ConnectionProvider> connectionProviderClass(Class<?> providerClass) {
        if (!ConnectionProvider.class.isAssignableFrom(providerClass)) {
            throw new ConnectionProviderConfigurationException("Class '" + providerClass.getName() + "' does not implement 'ConnectionProvider'");
        }
        Class<?> connectionProviderClass = providerClass;
        return connectionProviderClass;
    }

    private ConnectionProvider instantiateNamedConnectionProvider(String providerName, StrategySelector strategySelector, BeanContainer beanContainer) {
        LOG.instantiatingExplicitConnectionProvider(providerName);
        Class<ConnectionProvider> providerClass = strategySelector.selectStrategyImplementor(ConnectionProvider.class, providerName);
        try {
            return this.instantiateExplicitConnectionProvider(providerClass, beanContainer);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate connection provider [" + providerName + "]", e);
        }
    }

    private ConnectionProvider instantiateConnectionProvider(Map<String, Object> configurationValues, StrategySelector strategySelector, BeanContainer beanContainer) {
        if (configurationValues.containsKey("hibernate.connection.datasource")) {
            return new DatasourceConnectionProviderImpl();
        }
        Class<? extends ConnectionProvider> singleRegisteredProvider = this.getSingleRegisteredProvider(strategySelector);
        if (singleRegisteredProvider != null) {
            try {
                return singleRegisteredProvider.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new HibernateException("Could not instantiate singular-registered ConnectionProvider", e);
            }
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.c3p0")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, C3P0_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.hikari")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, HIKARI_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.agroal")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, AGROAL_STRATEGY);
        }
        if (configurationValues.containsKey("hibernate.connection.url")) {
            return new DriverManagerConnectionProviderImpl();
        }
        if (beanContainer != null) {
            return Helper.getBean(beanContainer, ConnectionProvider.class, true, true, this::noAppropriateConnectionProvider);
        }
        return this.noAppropriateConnectionProvider();
    }

    private ConnectionProvider noAppropriateConnectionProvider() {
        LOG.noAppropriateConnectionProvider();
        return new UserSuppliedConnectionProviderImpl();
    }

    private Class<? extends ConnectionProvider> getSingleRegisteredProvider(StrategySelector strategySelector) {
        Collection<Class<ConnectionProvider>> implementors = strategySelector.getRegisteredStrategyImplementors(ConnectionProvider.class);
        return implementors != null && implementors.size() == 1 ? implementors.iterator().next() : null;
    }

    private <T extends ConnectionProvider> T instantiateExplicitConnectionProvider(Class<T> providerClass, BeanContainer beanContainer) {
        try {
            if (beanContainer != null) {
                return (T)Helper.getBean(beanContainer, providerClass, true, true, () -> {
                    try {
                        return (ConnectionProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new HibernateException("Could not instantiate connection provider [" + providerClass.getName() + "]", e);
                    }
                });
            }
            return (T)((ConnectionProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate connection provider [" + providerClass.getName() + "]", e);
        }
    }

    private static ConnectionProvider instantiateProvider(StrategySelector selector, String strategy) {
        try {
            return selector.selectStrategyImplementor(ConnectionProvider.class, strategy).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.providerClassNotFound(strategy);
            return null;
        }
    }

    public static Properties getConnectionProperties(Map<String, Object> properties) {
        Properties result = new Properties();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof String)) continue;
            String value = (String)object;
            String key = entry.getKey();
            if (key.startsWith("hibernate.connection")) {
                if (SPECIAL_PROPERTIES.contains(key)) {
                    if (!"hibernate.connection.username".equals(key)) continue;
                    result.setProperty("user", value);
                    continue;
                }
                result.setProperty(key.substring("hibernate.connection".length() + 1), value);
                continue;
            }
            if (!CONDITIONAL_PROPERTIES.containsKey(key)) continue;
            result.setProperty(CONDITIONAL_PROPERTIES.get(key), value);
        }
        return result;
    }

    public static Integer extractIsolation(Map<String, ?> settings) {
        return ConnectionProviderInitiator.interpretIsolation(settings.get("hibernate.connection.isolation"));
    }

    public static Integer interpretIsolation(Object setting) {
        if (setting == null) {
            return null;
        }
        if (setting instanceof Number) {
            Number number = (Number)setting;
            int isolationLevel = number.intValue();
            ConnectionProviderInitiator.checkIsolationLevel(isolationLevel);
            return isolationLevel;
        }
        String string = setting.toString();
        if (StringHelper.isBlank(string)) {
            return null;
        }
        if (ISOLATION_VALUE_MAP.containsKey(string)) {
            return ISOLATION_VALUE_MAP.get(string);
        }
        try {
            int isolationLevel = Integer.parseInt(string);
            ConnectionProviderInitiator.checkIsolationLevel(isolationLevel);
            return isolationLevel;
        }
        catch (NumberFormatException ignore) {
            throw new ConnectionProviderConfigurationException("Unknown transaction isolation level: '" + string + "'");
        }
    }

    private static void checkIsolationLevel(int isolationLevel) {
        if (!ISOLATION_VALUE_CONSTANT_NAME_MAP.containsKey(isolationLevel)) {
            throw new ConnectionProviderConfigurationException("Unknown transaction isolation level: " + isolationLevel);
        }
    }

    public static String toIsolationConnectionConstantName(Integer isolation) {
        String name = ISOLATION_VALUE_CONSTANT_NAME_MAP.get(isolation);
        if (name == null) {
            throw new HibernateException("Could not convert isolation value [" + isolation + "] to java.sql.Connection constant name");
        }
        return name;
    }

    public static String toIsolationNiceName(Integer isolation) {
        String name = isolation != null ? ISOLATION_VALUE_NICE_NAME_MAP.get(isolation) : null;
        return name == null ? "<unknown>" : name;
    }

    public static String extractSetting(Map<String, Object> settings, String ... names) {
        for (String name : names) {
            if (!settings.containsKey(name)) continue;
            return (String)settings.get(name);
        }
        return null;
    }

    public static void consumeSetting(Map<String, Object> settings, SettingConsumer consumer, String ... names) {
        for (String name : names) {
            Object setting = settings.get(name);
            if (setting == null) continue;
            consumer.consumeSetting(name, setting.toString());
            return;
        }
    }

    private static boolean hasConfiguration(Map<String, Object> configValues, String namespace) {
        String prefix = namespace + ".";
        for (String key : configValues.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_disables_autocommit");
        ISOLATION_VALUE_MAP = new ConcurrentHashMap<String, Integer>();
        ISOLATION_VALUE_MAP.put("TRANSACTION_NONE", 0);
        ISOLATION_VALUE_MAP.put("NONE", 0);
        ISOLATION_VALUE_MAP.put("TRANSACTION_READ_UNCOMMITTED", 1);
        ISOLATION_VALUE_MAP.put("READ_UNCOMMITTED", 1);
        ISOLATION_VALUE_MAP.put("TRANSACTION_READ_COMMITTED", 2);
        ISOLATION_VALUE_MAP.put("READ_COMMITTED", 2);
        ISOLATION_VALUE_MAP.put("TRANSACTION_REPEATABLE_READ", 4);
        ISOLATION_VALUE_MAP.put("REPEATABLE_READ", 4);
        ISOLATION_VALUE_MAP.put("TRANSACTION_SERIALIZABLE", 8);
        ISOLATION_VALUE_MAP.put("SERIALIZABLE", 8);
        ISOLATION_VALUE_CONSTANT_NAME_MAP = new ConcurrentHashMap<Integer, String>();
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(0, "TRANSACTION_NONE");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(1, "TRANSACTION_READ_UNCOMMITTED");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(2, "TRANSACTION_READ_COMMITTED");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(4, "TRANSACTION_REPEATABLE_READ");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(8, "TRANSACTION_SERIALIZABLE");
        ISOLATION_VALUE_NICE_NAME_MAP = new ConcurrentHashMap<Integer, String>();
        ISOLATION_VALUE_NICE_NAME_MAP.put(0, "NONE");
        ISOLATION_VALUE_NICE_NAME_MAP.put(1, "READ_UNCOMMITTED");
        ISOLATION_VALUE_NICE_NAME_MAP.put(2, "READ_COMMITTED");
        ISOLATION_VALUE_NICE_NAME_MAP.put(4, "REPEATABLE_READ");
        ISOLATION_VALUE_NICE_NAME_MAP.put(8, "SERIALIZABLE");
        CONDITIONAL_PROPERTIES = Map.of("hibernate.synonyms", "includeSynonyms");
    }

    @FunctionalInterface
    public static interface SettingConsumer {
        public void consumeSetting(String var1, String var2);
    }
}

