/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.util.Locale;
import java.util.TreeSet;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.model.naming.DatabaseIdentifier;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;

public class NormalizingIdentifierHelperImpl
implements IdentifierHelper {
    private final JdbcEnvironment jdbcEnvironment;
    private final NameQualifierSupport nameQualifierSupport;
    private final boolean globallyQuoteIdentifiers;
    private final boolean globallyQuoteIdentifiersSkipColumnDefinitions;
    private final boolean autoQuoteKeywords;
    private final boolean autoQuoteInitialUnderscore;
    private final boolean autoQuoteDollar;
    private final TreeSet<String> reservedWords;
    private final IdentifierCaseStrategy unquotedCaseStrategy;
    private final IdentifierCaseStrategy quotedCaseStrategy;

    public NormalizingIdentifierHelperImpl(JdbcEnvironment jdbcEnvironment, NameQualifierSupport nameQualifierSupport, boolean globallyQuoteIdentifiers, boolean globallyQuoteIdentifiersSkipColumnDefinitions, boolean autoQuoteKeywords, boolean autoQuoteInitialUnderscore, boolean autoQuoteDollar, TreeSet<String> reservedWords, IdentifierCaseStrategy unquotedCaseStrategy, IdentifierCaseStrategy quotedCaseStrategy) {
        this.jdbcEnvironment = jdbcEnvironment;
        this.nameQualifierSupport = nameQualifierSupport;
        this.globallyQuoteIdentifiers = globallyQuoteIdentifiers;
        this.globallyQuoteIdentifiersSkipColumnDefinitions = globallyQuoteIdentifiersSkipColumnDefinitions;
        this.autoQuoteKeywords = autoQuoteKeywords;
        this.autoQuoteInitialUnderscore = autoQuoteInitialUnderscore;
        this.autoQuoteDollar = autoQuoteDollar;
        this.reservedWords = reservedWords;
        this.unquotedCaseStrategy = unquotedCaseStrategy == null ? IdentifierCaseStrategy.UPPER : unquotedCaseStrategy;
        this.quotedCaseStrategy = quotedCaseStrategy == null ? IdentifierCaseStrategy.MIXED : quotedCaseStrategy;
    }

    @Override
    public Identifier normalizeQuoting(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.isQuoted()) {
            return identifier;
        }
        if (this.mustQuote(identifier)) {
            return Identifier.toIdentifier(identifier.getText(), true);
        }
        return identifier;
    }

    private boolean mustQuote(Identifier identifier) {
        return this.globallyQuoteIdentifiers || this.autoQuoteKeywords && this.isReservedWord(identifier.getText()) || this.autoQuoteInitialUnderscore && identifier.getText().startsWith("_") || this.autoQuoteDollar && identifier.getText().contains("$");
    }

    @Override
    public Identifier toIdentifier(String text) {
        return this.normalizeQuoting(Identifier.toIdentifier(text));
    }

    @Override
    public Identifier toIdentifier(String text, boolean quoted) {
        return this.normalizeQuoting(Identifier.toIdentifier(text, quoted));
    }

    @Override
    public Identifier applyGlobalQuoting(String text) {
        return Identifier.toIdentifier(text, this.globallyQuoteIdentifiers && !this.globallyQuoteIdentifiersSkipColumnDefinitions, false);
    }

    @Override
    public boolean isReservedWord(String word) {
        if (!this.autoQuoteKeywords) {
            throw new AssertionFailure("The reserved keywords map is only initialized if autoQuoteKeywords is true");
        }
        return this.reservedWords.contains(word);
    }

    @Override
    public String toMetaDataCatalogName(Identifier identifier) {
        if (!this.nameQualifierSupport.supportsCatalogs()) {
            return null;
        }
        if (identifier == null) {
            if (this.jdbcEnvironment.getCurrentCatalog() == null) {
                return "";
            }
            identifier = this.jdbcEnvironment.getCurrentCatalog();
        }
        return this.toMetaDataText(identifier);
    }

    private String toMetaDataText(Identifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier cannot be null; bad usage");
        }
        String text = identifier.getText();
        if (identifier instanceof DatabaseIdentifier) {
            return text;
        }
        if (identifier.isQuoted()) {
            return switch (this.quotedCaseStrategy) {
                default -> throw new IncompatibleClassChangeError();
                case IdentifierCaseStrategy.UPPER -> text.toUpperCase(Locale.ROOT);
                case IdentifierCaseStrategy.LOWER -> text.toLowerCase(Locale.ROOT);
                case IdentifierCaseStrategy.MIXED -> text;
            };
        }
        return switch (this.unquotedCaseStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case IdentifierCaseStrategy.MIXED -> text;
            case IdentifierCaseStrategy.LOWER -> text.toLowerCase(Locale.ROOT);
            case IdentifierCaseStrategy.UPPER -> text.toUpperCase(Locale.ROOT);
        };
    }

    @Override
    public String toMetaDataSchemaName(Identifier identifier) {
        if (!this.nameQualifierSupport.supportsSchemas()) {
            return null;
        }
        if (identifier == null) {
            if (this.jdbcEnvironment.getCurrentSchema() == null) {
                return "";
            }
            identifier = this.jdbcEnvironment.getCurrentSchema();
        }
        return this.toMetaDataText(identifier);
    }

    @Override
    public String toMetaDataObjectName(Identifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("null was passed as an object name");
        }
        return this.toMetaDataText(identifier);
    }
}

