/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.spi;

import java.util.concurrent.TimeUnit;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.service.Service;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class SqlStatementLogger
implements Service {
    private static final Logger LOG = CoreLogging.logger("org.hibernate.SQL");
    private static final Logger LOG_SLOW = CoreLogging.logger("org.hibernate.SQL_SLOW");
    private final boolean logToStdout;
    private final boolean format;
    private final boolean highlight;
    private final long logSlowQuery;

    public SqlStatementLogger() {
        this(false, false, false);
    }

    public SqlStatementLogger(boolean logToStdout, boolean format) {
        this(logToStdout, format, false);
    }

    public SqlStatementLogger(boolean logToStdout, boolean format, boolean highlight) {
        this(logToStdout, format, highlight, 0L);
    }

    public SqlStatementLogger(boolean logToStdout, boolean format, boolean highlight, long logSlowQuery) {
        this.logToStdout = logToStdout;
        this.format = format;
        this.highlight = highlight;
        this.logSlowQuery = logSlowQuery;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    public boolean isFormat() {
        return this.format;
    }

    public long getLogSlowQuery() {
        return this.logSlowQuery;
    }

    public void logStatement(String statement) {
        this.logStatement(statement, FormatStyle.BASIC.getFormatter());
    }

    @AllowSysOut
    public void logStatement(String statement, Formatter formatter) {
        if (!this.logToStdout && !LOG.isDebugEnabled()) {
            return;
        }
        try {
            if (this.format) {
                statement = formatter.format(statement);
            }
            if (this.highlight) {
                statement = FormatStyle.HIGHLIGHT.getFormatter().format(statement);
            }
        }
        catch (RuntimeException ex) {
            LOG.warn((Object)"Couldn't format statement", (Throwable)ex);
        }
        LOG.debug((Object)statement);
        if (this.logToStdout) {
            String prefix = this.highlight ? "\u001b[35m[Hibernate]\u001b[0m " : "Hibernate: ";
            System.out.println(prefix + statement);
        }
    }

    public void logSlowQuery(String sql, long startTimeNanos, JdbcSessionContext context) {
        if (this.logSlowQuery < 1L) {
            return;
        }
        if (startTimeNanos <= 0L) {
            throw new IllegalArgumentException("startTimeNanos [" + startTimeNanos + "] should be greater than 0");
        }
        long queryExecutionMillis = SqlStatementLogger.elapsedFrom(startTimeNanos);
        if (queryExecutionMillis > this.logSlowQuery) {
            this.logSlowQueryInternal(context, queryExecutionMillis, sql);
        }
    }

    private static long elapsedFrom(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNanos);
    }

    @AllowSysOut
    private void logSlowQueryInternal(JdbcSessionContext context, long queryExecutionMillis, String sql) {
        StatisticsImplementor statisticsImplementor;
        String logData = "Slow query took " + queryExecutionMillis + " milliseconds [" + sql + "]";
        LOG_SLOW.info((Object)logData);
        if (this.logToStdout) {
            System.out.println(logData);
        }
        if (context != null && (statisticsImplementor = context.getStatistics()) != null && statisticsImplementor.isStatisticsEnabled()) {
            statisticsImplementor.slowQuery(sql, queryExecutionMillis);
        }
    }
}

