/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformResolver;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class JtaPlatformInitiator
implements StandardServiceInitiator<JtaPlatform> {
    public static final JtaPlatformInitiator INSTANCE = new JtaPlatformInitiator();
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)JtaPlatformInitiator.class.getName());

    @Override
    public Class<JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    @Override
    public @Nullable JtaPlatform initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Object setting = configurationValues.get("hibernate.transaction.jta.platform");
        JtaPlatform platform = registry.requireService(StrategySelector.class).resolveStrategy(JtaPlatform.class, setting);
        if (platform == null) {
            LOG.trace("No JtaPlatform was specified, checking resolver");
            platform = registry.requireService(JtaPlatformResolver.class).resolveJtaPlatform(configurationValues, registry);
        }
        if (platform == null) {
            LOG.trace("No JtaPlatform was specified, checking fallback provider");
            platform = this.getFallbackProvider(configurationValues, registry);
        }
        if (platform == null || platform instanceof NoJtaPlatform) {
            LOG.noJtaPlatform();
        } else {
            LOG.usingJtaPlatform(platform.getClass().getName());
        }
        return platform;
    }

    protected @Nullable JtaPlatform getFallbackProvider(Map<?, ?> configurationValues, ServiceRegistryImplementor registry) {
        return null;
    }
}

