/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;

public final class LockOptionsHelper {
    private LockOptionsHelper() {
    }

    public static void applyPropertiesToLockOptions(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        LockOptionsHelper.applyScope(props, lockOptions);
        LockOptionsHelper.applyTimeout(props, lockOptions);
        LockOptionsHelper.applyFollowOn(props, lockOptions);
    }

    private static void applyScope(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        String lockScopeHint = "jakarta.persistence.lock.scope";
        Object value = props.get(lockScopeHint);
        if (value == null) {
            lockScopeHint = "javax.persistence.lock.scope";
            value = props.get(lockScopeHint);
        }
        if (value instanceof Locking.Scope) {
            Locking.Scope scope = (Locking.Scope)((Object)value);
            lockOptions.get().setScope(scope);
        } else if (value instanceof PessimisticLockScope) {
            PessimisticLockScope pessimisticLockScope = (PessimisticLockScope)value;
            lockOptions.get().setLockScope(pessimisticLockScope);
        } else if (value instanceof String) {
            String string = (String)value;
            Locking.Scope scope = Locking.Scope.interpret(string);
            if (scope != null) {
                lockOptions.get().setScope(scope);
            }
        } else if (value != null) {
            throw new PersistenceException("Unable to interpret " + lockScopeHint + ": " + String.valueOf(value));
        }
    }

    private static void applyTimeout(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        String timeoutHint = "jakarta.persistence.lock.timeout";
        Object lockTimeout = props.get(timeoutHint);
        if (lockTimeout == null && (lockTimeout = props.get(timeoutHint = "javax.persistence.lock.timeout")) != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedHint("javax.persistence.lock.timeout", "jakarta.persistence.lock.timeout");
        }
        if (lockTimeout instanceof Timeout) {
            Timeout timeout = (Timeout)lockTimeout;
            lockOptions.get().setTimeout(timeout);
        } else if (lockTimeout instanceof String) {
            String string = (String)lockTimeout;
            lockOptions.get().setTimeOut(Integer.parseInt(string));
        } else if (lockTimeout instanceof Number) {
            Number number = (Number)lockTimeout;
            int timeout = number.intValue();
            lockOptions.get().setTimeOut(timeout);
        } else if (lockTimeout != null) {
            throw new PersistenceException("Unable to interpret " + timeoutHint + ": " + String.valueOf(lockTimeout));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void applyFollowOn(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        Object strategyValue = props.get("hibernate.query.followOnStrategy");
        if (strategyValue != null) {
            if (strategyValue instanceof Locking.FollowOn) {
                Locking.FollowOn strategy = (Locking.FollowOn)((Object)strategyValue);
                lockOptions.get().setFollowOnStrategy(strategy);
                return;
            } else {
                if (!(strategyValue instanceof String)) throw new PersistenceException("Unable to interpret hibernate.query.followOnStrategy: " + String.valueOf(strategyValue));
                String name = (String)strategyValue;
                lockOptions.get().setFollowOnStrategy(Locking.FollowOn.interpret(name));
            }
            return;
        } else {
            if (!props.containsKey("hibernate.query.followOnLocking")) return;
            Locking.FollowOn strategyFromLegacy = Locking.FollowOn.fromLegacyValue(ConfigurationHelper.getBoolean("hibernate.query.followOnLocking", props));
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedHint("hibernate.query.followOnLocking", "hibernate.query.followOnStrategy");
            lockOptions.get().setFollowOnStrategy(strategyFromLegacy);
        }
    }
}

