/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.StaleStateException;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.BatchFailedException;
import org.hibernate.jdbc.BatchedTooManyRowsAffectedException;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.TooManyRowsAffectedException;

public class Expectations {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(Expectations.class);
    static final SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper(false);
    @Deprecated(since="6.5")
    public static final Expectation NONE = new Expectation.None();
    @Deprecated(since="6.5")
    public static final Expectation BASIC = new Expectation.RowCount();
    @Deprecated(since="6.5")
    public static final Expectation PARAM = new Expectation.OutParameter();

    @Internal
    public static Expectation createExpectation(Supplier<? extends Expectation> expectation, boolean callable) {
        Expectation instance = Expectations.instantiate(expectation, callable);
        instance.validate(callable);
        return instance;
    }

    private static Expectation instantiate(Supplier<? extends Expectation> supplier, boolean callable) {
        if (supplier == null) {
            return callable ? new Expectation.OutParameter() : new Expectation.RowCount();
        }
        return supplier.get();
    }

    static CallableStatement toCallableStatement(PreparedStatement statement) {
        if (statement instanceof CallableStatement) {
            CallableStatement callableStatement = (CallableStatement)statement;
            return callableStatement;
        }
        throw new HibernateException("Expectation.OutParameter operates exclusively on CallableStatements: " + String.valueOf(statement.getClass()));
    }

    static void checkBatched(int expectedRowCount, int rowCount, int batchPosition, String sql) {
        switch (rowCount) {
            case -3: {
                throw new BatchFailedException("Batch update failed: " + batchPosition);
            }
            case -2: {
                LOG.debugf("Success of batch update unknown: %s", batchPosition);
                break;
            }
            default: {
                if (expectedRowCount > rowCount) {
                    throw new StaleStateException("Batch update returned unexpected row count from update " + batchPosition + Expectations.actualVsExpected(expectedRowCount, rowCount) + " [" + sql + "]");
                }
                if (expectedRowCount >= rowCount) break;
                throw new BatchedTooManyRowsAffectedException("Batch update returned unexpected row count from update " + batchPosition + Expectations.actualVsExpected(expectedRowCount, rowCount), expectedRowCount, rowCount, batchPosition);
            }
        }
    }

    static void checkNonBatched(int expectedRowCount, int rowCount, String sql) {
        if (expectedRowCount > rowCount) {
            throw new StaleStateException("Unexpected row count" + Expectations.actualVsExpected(expectedRowCount, rowCount) + " [" + sql + "]");
        }
        if (expectedRowCount < rowCount) {
            throw new TooManyRowsAffectedException("Unexpected row count" + Expectations.actualVsExpected(expectedRowCount, rowCount), 1, rowCount);
        }
    }

    private static String actualVsExpected(int expectedRowCount, int rowCount) {
        return " (expected row count " + expectedRowCount + " but was " + rowCount + ")";
    }

    private Expectations() {
    }
}

