/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.ExcludeDefaultListeners;
import jakarta.persistence.ExcludeSuperclassListeners;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PersistenceException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.models.spi.JpaEventListener;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.event.internal.EmbeddableCallback;
import org.hibernate.jpa.event.internal.EntityCallback;
import org.hibernate.jpa.event.internal.ListenerCallback;
import org.hibernate.jpa.event.spi.CallbackDefinition;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.property.access.spi.Getter;

public final class CallbackDefinitionResolver {
    private static boolean useAnnotationAnnotatedByListener = false;

    private static List<CallbackDefinition> resolveEntityCallbacks(InFlightMetadataCollector metadataCollector, ClassDetails entityClass, CallbackType callbackType) {
        List<JpaEventListener> globalListenerRegistrations;
        ModelsContext modelsContext = metadataCollector.getBootstrapContext().getModelsContext();
        ArrayList<CallbackDefinition> callbackDefinitions = new ArrayList<CallbackDefinition>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ArrayList<ClassDetails> orderedListeners = new ArrayList<ClassDetails>();
        ClassDetails currentClazz = entityClass;
        boolean stopListeners = false;
        boolean stopDefaultListeners = false;
        do {
            EntityCallback.Definition callbackDefinition = null;
            List methodsDetailsList = currentClazz.getMethods();
            for (MethodDetails methodDetails : methodsDetailsList) {
                if (!methodDetails.hasDirectAnnotationUsage(callbackType.getCallbackAnnotation()) || callbacksMethodNames.contains(methodDetails.getName())) continue;
                if (callbackDefinition == null) {
                    Method javaMethod = methodDetails.toJavaMember();
                    callbackDefinition = new EntityCallback.Definition(javaMethod, callbackType);
                    Class<?> returnType = javaMethod.getReturnType();
                    Class<?>[] args = javaMethod.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + callbackType.getCallbackAnnotation().getName() + " - " + String.valueOf(methodDetails));
                    }
                    ReflectHelper.ensureAccessibility(javaMethod);
                    callbackDefinitions.add(0, callbackDefinition);
                    callbacksMethodNames.add(0, methodDetails.getName());
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + entityClass.getName());
            }
            if (!stopListeners) {
                CallbackDefinitionResolver.applyListeners(currentClazz, orderedListeners, modelsContext);
                stopListeners = currentClazz.hasDirectAnnotationUsage(ExcludeSuperclassListeners.class);
                stopDefaultListeners = currentClazz.hasDirectAnnotationUsage(ExcludeDefaultListeners.class);
            }
            while ((currentClazz = currentClazz.getSuperClass()) != null && !currentClazz.hasDirectAnnotationUsage(Entity.class) && !currentClazz.hasDirectAnnotationUsage(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        if (!stopDefaultListeners && CollectionHelper.isNotEmpty(globalListenerRegistrations = metadataCollector.getGlobalRegistrations().getEntityListenerRegistrations())) {
            int defaultListenerSize = globalListenerRegistrations.size();
            for (int i = defaultListenerSize - 1; i >= 0; --i) {
                orderedListeners.add(globalListenerRegistrations.get(i).getCallbackClass());
            }
        }
        for (ClassDetails listenerClassDetails : orderedListeners) {
            ListenerCallback.Definition callbackDefinition = null;
            if (listenerClassDetails == null) continue;
            for (MethodDetails methodDetails : listenerClassDetails.getMethods()) {
                if (!methodDetails.hasDirectAnnotationUsage(callbackType.getCallbackAnnotation())) continue;
                if (callbackDefinition == null) {
                    Method method = methodDetails.toJavaMember();
                    Class listenerClass = listenerClassDetails.toJavaClass();
                    callbackDefinition = new ListenerCallback.Definition(listenerClass, method, callbackType);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 1) {
                        throw new PersistenceException("Callback methods annotated in a listener bean class must return void and take one argument: " + callbackType.getCallbackAnnotation().getName() + " - " + String.valueOf(methodDetails));
                    }
                    ReflectHelper.ensureAccessibility(method);
                    callbackDefinitions.add(0, callbackDefinition);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + entityClass.getName() + " and callback listener: " + listenerClassDetails.getName());
            }
        }
        return callbackDefinitions;
    }

    @Deprecated(since="7")
    private static List<CallbackDefinition> resolveEmbeddableCallbacks(InFlightMetadataCollector metadataCollector, Class<?> entityClass, Property embeddableProperty, CallbackType callbackType) {
        ModelsContext modelsContext = metadataCollector.getBootstrapContext().getModelsContext();
        Class<?> embeddableClass = embeddableProperty.getType().getReturnedClass();
        ClassDetails embeddableClassDetails = modelsContext.getClassDetailsRegistry().getClassDetails(embeddableClass.getName());
        Getter embeddableGetter = embeddableProperty.getGetter(entityClass);
        ArrayList<CallbackDefinition> callbackDefinitions = new ArrayList<CallbackDefinition>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ClassDetails currentClass = embeddableClassDetails;
        do {
            EmbeddableCallback.Definition callbackDefinition = null;
            List methodsDetailsList = currentClass.getMethods();
            for (MethodDetails methodDetails : methodsDetailsList) {
                if (!methodDetails.hasDirectAnnotationUsage(callbackType.getCallbackAnnotation())) continue;
                Method method = methodDetails.toJavaMember();
                String methodName = method.getName();
                String callbackName = callbackType.getCallbackAnnotation().getName();
                String currentClassName = currentClass.getName();
                DeprecationLogger.DEPRECATION_LOGGER.embeddableLifecycleCallback(callbackName, currentClassName);
                if (callbacksMethodNames.contains(methodName)) {
                    throw new PersistenceException("Multiple callback methods annotated '@" + callbackName + "' in bean class '" + currentClassName + "'");
                }
                if (callbackDefinition != null) continue;
                callbackDefinition = new EmbeddableCallback.Definition(embeddableGetter, method, callbackType);
                Class<?> returnType = method.getReturnType();
                Class<?>[] args = method.getParameterTypes();
                if (returnType != Void.TYPE || args.length != 0) {
                    throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + callbackName + " - " + String.valueOf(methodDetails));
                }
                ReflectHelper.ensureAccessibility(method);
                callbackDefinitions.add(0, callbackDefinition);
                callbacksMethodNames.add(0, methodName);
            }
            while ((currentClass = currentClass.getSuperClass()) != null && !currentClass.hasDirectAnnotationUsage(MappedSuperclass.class)) {
            }
        } while (currentClass != null);
        return callbackDefinitions;
    }

    private static void applyListeners(ClassDetails currentClazz, List<ClassDetails> listOfListeners, ModelsContext sourceModelContext) {
        ClassDetailsRegistry classDetailsRegistry = sourceModelContext.getClassDetailsRegistry();
        EntityListeners entityListeners = (EntityListeners)currentClazz.getDirectAnnotationUsage(EntityListeners.class);
        if (entityListeners != null) {
            Class[] listeners = entityListeners.value();
            int size = listeners.length;
            for (int index = size - 1; index >= 0; --index) {
                listOfListeners.add(classDetailsRegistry.resolveClassDetails(listeners[index].getName()));
            }
        }
        if (useAnnotationAnnotatedByListener) {
            List metaAnnotatedUsageList = currentClazz.getMetaAnnotated(EntityListeners.class, sourceModelContext);
            for (Annotation metaAnnotatedUsage : metaAnnotatedUsageList) {
                AnnotationDescriptor descriptor = sourceModelContext.getAnnotationDescriptorRegistry().getDescriptor(metaAnnotatedUsage.getClass());
                EntityListeners metaAnnotatedListeners = (EntityListeners)descriptor.getDirectAnnotationUsage(EntityListeners.class);
                Class[] listeners = metaAnnotatedListeners.value();
                for (int index = listeners.length - 1; index >= 0; --index) {
                    listOfListeners.add(classDetailsRegistry.resolveClassDetails(listeners[index].getName()));
                }
            }
        }
    }

    public static void resolveLifecycleCallbacks(ClassDetails entityClass, PersistentClass persistentClass, InFlightMetadataCollector collector) {
        for (CallbackType callbackType : CallbackType.values()) {
            persistentClass.addCallbackDefinitions(CallbackDefinitionResolver.resolveEntityCallbacks(collector, entityClass, callbackType));
        }
        collector.addSecondPass(persistentClasses -> {
            for (Property property : persistentClass.getDeclaredProperties()) {
                Component component;
                Value patt0$temp = property.getValue();
                if (!(patt0$temp instanceof Component) || (component = (Component)patt0$temp).isEmbedded()) continue;
                try {
                    Class<?> mappedClass = persistentClass.getMappedClass();
                    for (CallbackType type : CallbackType.values()) {
                        property.addCallbackDefinitions(CallbackDefinitionResolver.resolveEmbeddableCallbacks(collector, mappedClass, property, type));
                    }
                }
                catch (ClassLoadingException classLoadingException) {
                }
            }
        });
    }

    static {
        Target target = EntityListeners.class.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType type : target.value()) {
                if (!type.equals((Object)ElementType.ANNOTATION_TYPE)) continue;
                useAnnotationAnnotatedByListener = true;
                break;
            }
        }
    }
}

