/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.LockOptions;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.AbstractCollectionBatchLoader;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadChunker;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class CollectionBatchLoaderInPredicate
extends AbstractCollectionBatchLoader
implements SqlArrayMultiKeyLoader {
    private final int keyColumnCount;
    private final int sqlBatchSize;
    private final JdbcParametersList jdbcParameters;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelect;

    public CollectionBatchLoaderInPredicate(int domainBatchSize, LoadQueryInfluencers influencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        super(domainBatchSize, influencers, attributeMapping, sessionFactory);
        this.keyColumnCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        this.sqlBatchSize = sessionFactory.getJdbcServices().getDialect().getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.keyColumnCount, domainBatchSize, false);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Batch fetching enabled for collection '%s' using IN-predicate with batch size %s (%s)", (Object)attributeMapping.getNavigableRole().getFullPath(), (Object)this.sqlBatchSize, (Object)domainBatchSize);
        }
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), null, this.sqlBatchSize, influencers, new LockOptions(), jdbcParametersBuilder::add, sessionFactory);
        QuerySpec querySpec = this.sqlAst.getQueryPart().getFirstQuerySpec();
        TableGroup tableGroup = querySpec.getFromClause().getRoots().get(0);
        attributeMapping.applySoftDeleteRestrictions(tableGroup, querySpec::applyPredicate);
        this.jdbcParameters = jdbcParametersBuilder.build();
        assert (this.jdbcParameters.size() == this.sqlBatchSize * this.keyColumnCount);
        this.jdbcSelect = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    void initializeKeys(Object key, Object[] keysToInitialize, SharedSessionContractImplementor session) {
        boolean loggerDebugEnabled = MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled();
        if (loggerDebugEnabled) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Collection keys to initialize via batch fetching (%s) %s", (Object)MessageHelper.collectionInfoString(this.getLoadable(), key), (Object)keysToInitialize);
        }
        MultiKeyLoadChunker<Object> chunker = new MultiKeyLoadChunker<Object>(this.sqlBatchSize, this.keyColumnCount, this.getLoadable().getKeyDescriptor(), this.jdbcParameters, this.sqlAst, this.jdbcSelect);
        BatchFetchQueue batchFetchQueue = session.getPersistenceContextInternal().getBatchFetchQueue();
        chunker.processChunks(keysToInitialize, MultiKeyLoadHelper.countIds(keysToInitialize), (jdbcParameterBindings, session1) -> {
            SubselectFetch.RegistrationHandler registrationHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, this.sqlAst, this.jdbcParameters, jdbcParameterBindings);
            return new ExecutionContextWithSubselectFetchHandler(session, registrationHandler);
        }, (key1, relativePosition, absolutePosition) -> {}, startIndex -> {
            if (loggerDebugEnabled) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Processing collection batch-fetch chunk (%s) %s - %s", (Object)MessageHelper.collectionInfoString(this.getLoadable(), key), (Object)startIndex, (Object)(startIndex + (this.sqlBatchSize - 1)));
            }
        }, (startIndex, nonNullElementCount) -> {
            if (loggerDebugEnabled) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Finishing collection batch-fetch chunk (%s) %s - %s (%s)", new Object[]{MessageHelper.collectionInfoString(this.getLoadable(), key), startIndex, startIndex + (this.sqlBatchSize - 1), nonNullElementCount});
            }
            for (int i = 0; i < nonNullElementCount; ++i) {
                int keyPosition = i + startIndex;
                if (keyPosition >= keysToInitialize.length) continue;
                this.finishInitializingKey(keysToInitialize[keyPosition], session);
            }
        }, session);
    }

    @Override
    void finishInitializingKeys(Object[] key, SharedSessionContractImplementor session) {
    }
}

