/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EmbeddableDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public interface EmbeddableMappingType
extends ManagedMappingType,
SelectableMappings {
    public EmbeddableValuedModelPart getEmbeddedValueMapping();

    public EmbeddableRepresentationStrategy getRepresentationStrategy();

    default public EmbeddableDiscriminatorMapping getDiscriminatorMapping() {
        return null;
    }

    default public boolean isPolymorphic() {
        return this.getDiscriminatorMapping() != null;
    }

    default public ConcreteEmbeddableType findSubtypeByDiscriminator(Object discriminatorValue) {
        return null;
    }

    default public ConcreteEmbeddableType findSubtypeBySubclass(String subclassName) {
        return null;
    }

    default public Collection<ConcreteEmbeddableType> getConcreteEmbeddableTypes() {
        return Collections.emptySet();
    }

    default public SelectableMapping getAggregateMapping() {
        return null;
    }

    default public boolean shouldSelectAggregateMapping() {
        return this.getAggregateMapping() != null;
    }

    @Override
    default public EmbeddableMappingType getPartMappingType() {
        return this;
    }

    default public boolean shouldMutateAggregateMapping() {
        return this.getAggregateMapping() != null;
    }

    default public boolean shouldBindAggregateMapping() {
        return this.getAggregateMapping() != null;
    }

    @Override
    default public boolean anyRequiresAggregateColumnWriter() {
        return this.requiresAggregateColumnWriter() || ManagedMappingType.super.anyRequiresAggregateColumnWriter();
    }

    default public boolean requiresAggregateColumnWriter() {
        SelectableMapping aggregateMapping = this.getAggregateMapping();
        if (aggregateMapping == null) {
            return false;
        }
        int aggregateSqlTypeCode = aggregateMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        return this.findContainingEntityMapping().getEntityPersister().getFactory().getJdbcServices().getDialect().getAggregateSupport().requiresAggregateCustomWriteExpressionRenderer(aggregateSqlTypeCode);
    }

    default public int getJdbcValueCount() {
        int numberOfAttributeMappings = this.getNumberOfAttributeMappings();
        int count = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            EmbeddableMappingType embeddableMappingType;
            AttributeMapping attributeMapping = this.getAttributeMapping(i);
            MappingType mappedType = attributeMapping.getMappedType();
            if (mappedType instanceof EmbeddableMappingType && (embeddableMappingType = (EmbeddableMappingType)mappedType).getAggregateMapping() != null) {
                ++count;
                continue;
            }
            count += attributeMapping.getJdbcTypeCount();
        }
        return count;
    }

    default public SelectableMapping getJdbcValueSelectable(int columnIndex) {
        int numberOfAttributeMappings = this.getNumberOfAttributeMappings();
        int count = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = this.getAttributeMapping(i);
            if (attributeMapping instanceof DiscriminatedAssociationAttributeMapping) {
                DiscriminatedAssociationAttributeMapping discriminatedAssociationAttributeMapping = (DiscriminatedAssociationAttributeMapping)attributeMapping;
                if (count == columnIndex) {
                    return discriminatedAssociationAttributeMapping.getDiscriminatorMapping();
                }
                if (++count == columnIndex) {
                    return discriminatedAssociationAttributeMapping.getKeyPart();
                }
                ++count;
                continue;
            }
            if (attributeMapping instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                if (toOneAttributeMapping.getSideNature() != ForeignKeyDescriptor.Nature.KEY) continue;
                ValuedModelPart keyPart = toOneAttributeMapping.getForeignKeyDescriptor().getKeyPart();
                if (keyPart instanceof BasicValuedMapping) {
                    if (count == columnIndex) {
                        return (SelectableMapping)((Object)keyPart);
                    }
                    ++count;
                    continue;
                }
                if (keyPart instanceof EmbeddableValuedModelPart) {
                    EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)keyPart;
                    EmbeddableMappingType mappingType = embeddableValuedModelPart.getEmbeddableTypeDescriptor();
                    SelectableMapping selectable = mappingType.getJdbcValueSelectable(columnIndex - count);
                    if (selectable != null) {
                        return selectable;
                    }
                    count += mappingType.getJdbcValueCount();
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported foreign key part: " + String.valueOf(keyPart));
            }
            if (attributeMapping instanceof EmbeddableValuedModelPart) {
                EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)((Object)attributeMapping);
                EmbeddableMappingType embeddableMappingType = embeddableValuedModelPart.getMappedType();
                SelectableMapping aggregateMapping = embeddableMappingType.getAggregateMapping();
                if (aggregateMapping == null) {
                    SelectableMapping subSelectable = embeddableMappingType.getJdbcValueSelectable(columnIndex - count);
                    if (subSelectable != null) {
                        return subSelectable;
                    }
                    count += embeddableMappingType.getJdbcValueCount();
                    continue;
                }
                if (count == columnIndex) {
                    return aggregateMapping;
                }
                ++count;
                continue;
            }
            if (count == columnIndex) {
                if (attributeMapping instanceof SelectableMapping) {
                    SelectableMapping selectableMapping = (SelectableMapping)((Object)attributeMapping);
                    return selectableMapping;
                }
                if (!1.$assertionsDisabled && attributeMapping.getJdbcTypeCount() != 0) {
                    throw new AssertionError();
                }
            }
            count += attributeMapping.getJdbcTypeCount();
        }
        if (this.isPolymorphic() && columnIndex == count) {
            return this.getDiscriminatorMapping();
        }
        return null;
    }

    @Override
    default public int getSelectableIndex(String selectableName) {
        int numberOfAttributeMappings = this.getNumberOfAttributeMappings();
        int offset = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = this.getAttributeMapping(i);
            MappingType mappedType = attributeMapping.getMappedType();
            if (mappedType instanceof EmbeddableMappingType) {
                EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
                SelectableMapping aggregateMapping = embeddableMappingType.getAggregateMapping();
                if (aggregateMapping != null) {
                    if (aggregateMapping.getSelectableName().equals(selectableName)) {
                        return offset;
                    }
                    ++offset;
                    continue;
                }
                int selectableIndex = embeddableMappingType.getSelectableIndex(selectableName);
                if (selectableIndex != -1) {
                    return offset + selectableIndex;
                }
                offset += embeddableMappingType.getJdbcTypeCount();
                continue;
            }
            if (attributeMapping instanceof SelectableMapping) {
                SelectableMapping selectableMapping2 = (SelectableMapping)((Object)attributeMapping);
                if (selectableMapping2.getSelectableName().equals(selectableName)) {
                    return offset;
                }
                ++offset;
                continue;
            }
            MutableInteger position = new MutableInteger(-1);
            int jdbcTypeCount = attributeMapping.forEachSelectable((selectionIndex, selectableMapping) -> {
                if (selectableMapping.getSelectableName().equals(selectableName)) {
                    position.set(selectionIndex);
                }
            });
            if (position.get() != -1) {
                return offset + position.get();
            }
            offset += jdbcTypeCount;
        }
        if (this.isPolymorphic() && this.getDiscriminatorMapping().getSelectableName().equals(selectableName)) {
            return offset;
        }
        return -1;
    }

    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping var1, TableGroupProducer var2, SelectableMappings var3, MappingModelCreationProcess var4);

    @Override
    default public int forEachSelectable(SelectableConsumer consumer) {
        return ManagedMappingType.super.forEachSelectable(consumer);
    }

    @Override
    public int forEachSelectable(int var1, SelectableConsumer var2);

    default public void forEachInsertable(int offset, SelectableConsumer consumer) {
        this.forEachSelectable(offset, (selectionIndex, selectableMapping) -> {
            if (!selectableMapping.isInsertable() || selectableMapping.isFormula()) {
                return;
            }
            consumer.accept(selectionIndex, selectableMapping);
        });
    }

    default public void forEachUpdatable(int offset, SelectableConsumer consumer) {
        this.forEachSelectable(offset, (selectionIndex, selectableMapping) -> {
            if (!selectableMapping.isUpdateable() || selectableMapping.isFormula()) {
                return;
            }
            consumer.accept(selectionIndex, selectableMapping);
        });
    }

    @Override
    public int getJdbcTypeCount();

    @Override
    public int forEachJdbcType(int var1, IndexedConsumer<JdbcMapping> var2);

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath var1, TableGroup var2, String var3, DomainResultCreationState var4);

    @Override
    default public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.forEachAttributeMapping((? super AttributeMapping attributeMapping) -> attributeMapping.applySqlSelections(navigablePath, tableGroup, creationState));
    }

    @Override
    default public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.forEachAttributeMapping((? super AttributeMapping attributeMapping) -> attributeMapping.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer));
    }

    default public int compare(Object value1, Object value2) {
        AttributeMappingsList attributeMappings = this.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attribute = attributeMappings.get(i);
            int comparison = attribute.compare(attribute.getValue(value1), attribute.getValue(value2));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface ConcreteEmbeddableType {
        public EmbeddableInstantiator getInstantiator();

        public int getSubclassId();

        public boolean declaresAttribute(AttributeMapping var1);

        public boolean declaresAttribute(int var1);

        public Object getDiscriminatorValue();
    }
}

