/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Attribute;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Member;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.BasicTypeImpl;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPersistentAttribute;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractAttribute<D, J, B>
implements SqmPersistentAttribute<D, J>,
Serializable {
    private final ManagedDomainType<D> declaringType;
    private final String name;
    private final JavaType<J> attributeJtd;
    private final AttributeClassification attributeClassification;
    private final SqmDomainType<B> valueType;
    private final transient Member member;

    protected AbstractAttribute(ManagedDomainType<D> declaringType, String name, JavaType<J> attributeJtd, AttributeClassification attributeClassification, SqmDomainType<B> valueType, Member member) {
        this.declaringType = declaringType;
        this.name = name;
        this.attributeJtd = attributeJtd;
        this.attributeClassification = attributeClassification;
        this.valueType = valueType;
        this.member = member;
    }

    public String getName() {
        return this.name;
    }

    public Class<J> getJavaType() {
        Class<J> clazz;
        SqmDomainType<B> sqmDomainType = this.valueType;
        if (sqmDomainType instanceof BasicTypeImpl) {
            BasicTypeImpl basicType = (BasicTypeImpl)sqmDomainType;
            clazz = basicType.getJavaType();
        } else {
            clazz = this.attributeJtd.getJavaTypeClass();
        }
        return clazz;
    }

    public SqmDomainType<B> getPathType() {
        return this.valueType;
    }

    @Override
    public JavaType<J> getAttributeJavaType() {
        return this.attributeJtd;
    }

    @Override
    public ManagedDomainType<D> getDeclaringType() {
        return this.declaringType;
    }

    public Member getJavaMember() {
        return this.member;
    }

    @Override
    public AttributeClassification getAttributeClassification() {
        return this.attributeClassification;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.getAttributeClassification().getJpaClassification();
    }

    @Override
    public DomainType<?> getValueGraphType() {
        return this.valueType;
    }

    NavigablePath getParentNavigablePath(SqmPath<?> parent) {
        EntityDomainType entityDomainType;
        NavigablePath parentNavigablePath;
        SqmPathSource<?> parentPathSource = parent.getResolvedModel();
        DomainType parentType = parentPathSource.getPathType();
        NavigablePath navigablePath = parentNavigablePath = parentPathSource instanceof PluralPersistentAttribute ? parent.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()) : parent.getNavigablePath();
        if (parentType != this.declaringType && parentType instanceof EntityDomainType && (entityDomainType = (EntityDomainType)parentType).findAttribute(this.name) == null) {
            return parentNavigablePath.treatAs(this.declaringType.getTypeName());
        }
        return parentNavigablePath;
    }

    public String toString() {
        return this.declaringType.getTypeName() + "#" + this.name + "(" + String.valueOf((Object)this.attributeClassification) + ")";
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.declaringType, this.name);
    }

    private static class SerialForm
    implements Serializable {
        private final ManagedDomainType<?> declaringType;
        private final String name;

        public SerialForm(ManagedDomainType<?> declaringType, String name) {
            this.declaringType = declaringType;
            this.name = name;
        }

        private Object readResolve() {
            return this.declaringType.findAttribute(this.name);
        }
    }
}

