/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PrimeAmongSecondarySupertypes;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyConfiguration;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyInterceptor;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;
import org.hibernate.type.CompositeType;

public class ByteBuddyProxyFactory
implements ProxyFactory,
Serializable {
    private final ByteBuddyProxyHelper byteBuddyProxyHelper;
    private Class<?> persistentClass;
    private String entityName;
    private Class<?>[] interfaces;
    private Method getIdentifierMethod;
    private Method setIdentifierMethod;
    private CompositeType componentIdType;
    private boolean overridesEquals;
    private Class<?> proxyClass;

    public ByteBuddyProxyFactory(ByteBuddyProxyHelper byteBuddyProxyHelper) {
        this.byteBuddyProxyHelper = byteBuddyProxyHelper;
    }

    @Override
    public void postInstantiate(String entityName, Class<?> persistentClass, Set<Class<?>> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.interfaces = this.toArray(interfaces);
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.componentIdType = componentIdType;
        this.overridesEquals = ReflectHelper.overridesEquals(persistentClass);
        this.proxyClass = this.byteBuddyProxyHelper.buildProxy(persistentClass, this.interfaces);
    }

    private Class<?>[] toArray(Set<Class<?>> interfaces) {
        return interfaces == null ? ArrayHelper.EMPTY_CLASS_ARRAY : interfaces.toArray(ArrayHelper.EMPTY_CLASS_ARRAY);
    }

    @Override
    public HibernateProxy getProxy(Object id, SharedSessionContractImplementor session) throws HibernateException {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(this.entityName, this.persistentClass, this.interfaces, id, this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType, session, this.overridesEquals);
        HibernateProxy instance = this.getHibernateProxy();
        ProxyConfiguration proxyConfiguration = instance.asProxyConfiguration();
        if (proxyConfiguration == null) {
            throw new HibernateException("Produced proxy does not correctly implement ProxyConfiguration");
        }
        proxyConfiguration.$$_hibernate_set_interceptor(interceptor);
        return instance;
    }

    private HibernateProxy getHibernateProxy() {
        PrimeAmongSecondarySupertypes internal = this.getHibernateProxyInternal();
        HibernateProxy hibernateProxy = internal.asHibernateProxy();
        if (hibernateProxy == null) {
            throw new HibernateException("Produced proxy does not correctly implement HibernateProxy");
        }
        return hibernateProxy;
    }

    private PrimeAmongSecondarySupertypes getHibernateProxyInternal() throws HibernateException {
        try {
            return (PrimeAmongSecondarySupertypes)this.proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Bytecode enhancement failed because no public, protected or package-private default constructor was found for entity '" + this.entityName + "' (private constructors don't work with runtime proxies)", e);
        }
        catch (Throwable t) {
            throw new HibernateException("Bytecode enhancement failed for entity '" + this.entityName + "'", t);
        }
    }
}

