/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.restriction;

import jakarta.persistence.criteria.FetchParent;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import org.hibernate.query.restriction.Path;

record NamedPathElement<X, U, V>(Path<? super X, U> parent, String attributeName, Class<V> attributeType) implements Path<X, V>
{
    @Override
    public Class<V> getType() {
        return this.attributeType;
    }

    @Override
    public jakarta.persistence.criteria.Path<V> path(Root<? extends X> root) {
        jakarta.persistence.criteria.Path path = this.parent.path(root).get(this.attributeName);
        if (!this.attributeType.isAssignableFrom(path.getJavaType())) {
            throw new IllegalArgumentException("Attribute '" + this.attributeName + "' is not of type '" + this.attributeType.getName() + "'");
        }
        return path;
    }

    @Override
    public FetchParent<?, V> fetch(Root<? extends X> root) {
        return this.parent.fetch(root).fetch(this.attributeName, JoinType.LEFT);
    }
}

