/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.complete;

import java.util.Objects;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.complete.CompleteResultBuilderBasicValued;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class CompleteResultBuilderBasicValuedStandard
implements CompleteResultBuilderBasicValued {
    private final String explicitColumnName;
    private final BasicValuedMapping explicitType;
    private final JavaType<?> explicitJavaType;

    public CompleteResultBuilderBasicValuedStandard(String explicitColumnName, BasicValuedMapping explicitType, JavaType<?> explicitJavaType) {
        assert (explicitType == null || explicitType.getJdbcMapping().getJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(explicitJavaType.getJavaTypeClass()));
        this.explicitColumnName = explicitColumnName;
        this.explicitType = explicitType;
        this.explicitJavaType = explicitJavaType;
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public Class<?> getJavaType() {
        return this.explicitJavaType == null ? null : this.explicitJavaType.getJavaTypeClass();
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        int jdbcPosition = this.explicitColumnName != null ? jdbcResultsMetadata.resolveColumnPosition(this.explicitColumnName) : creationStateImpl.getNumberOfProcessedSelections() + 1;
        String columnName = this.explicitColumnName != null ? this.explicitColumnName : jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        SqlSelection sqlSelection = this.sqlSelection(jdbcResultsMetadata, creationStateImpl, columnName, jdbcPosition);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), columnName, sqlSelection.getExpressionType().getSingleJdbcMapping(), null, false, false);
    }

    private SqlSelection sqlSelection(JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationStateImpl creationStateImpl, String columnName, int jdbcPosition) {
        TypeConfiguration typeConfiguration = creationStateImpl.getCreationContext().getTypeConfiguration();
        return creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnName), processingState -> {
            BasicType<?> basicType = this.explicitType != null ? this.explicitType : jdbcResultsMetadata.resolveType(jdbcPosition, this.explicitJavaType, typeConfiguration);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, basicType);
        }), this.explicitJavaType, null, typeConfiguration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteResultBuilderBasicValuedStandard that = (CompleteResultBuilderBasicValuedStandard)o;
        return Objects.equals(this.explicitColumnName, that.explicitColumnName) && Objects.equals(this.explicitType, that.explicitType) && Objects.equals(this.explicitJavaType, that.explicitJavaType);
    }

    public int hashCode() {
        return Objects.hash(this.explicitColumnName, this.explicitType, this.explicitJavaType);
    }
}

