/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmAggregateFunction;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class SelfRenderingSqmAggregateFunction<T>
extends SelfRenderingSqmFunction<T>
implements SqmAggregateFunction<T> {
    private final SqmPredicate filter;

    public SelfRenderingSqmAggregateFunction(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        this.filter = filter;
    }

    @Override
    public SelfRenderingSqmAggregateFunction<T> copy(SqmCopyContext context) {
        SelfRenderingSqmAggregateFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        SelfRenderingSqmAggregateFunction expression = context.registerCopy(this, new SelfRenderingSqmAggregateFunction(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.filter == null ? null : this.filter.copy(context), this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator argumentsValidator = this.getArgumentsValidator();
        if (argumentsValidator != null) {
            argumentsValidator.validateSqlTypes(arguments, this.getFunctionName());
        }
        return new SelfRenderingAggregateFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, this.filter == null ? null : walker.visitNestedTopLevelPredicate(this.filter), resultType, this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public SqmPredicate getFilter() {
        return this.filter;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        List<SqmTypedNode<?>> arguments = this.getArguments();
        hql.append(this.getFunctionName());
        hql.append('(');
        int i = 1;
        if (arguments.get(0) instanceof SqmDistinct) {
            arguments.get(0).appendHqlString(hql, context);
            if (arguments.size() > 1) {
                hql.append(' ');
                arguments.get(1).appendHqlString(hql, context);
                i = 2;
            }
        }
        while (i < arguments.size()) {
            hql.append(", ");
            arguments.get(i).appendHqlString(hql, context);
            ++i;
        }
        hql.append(')');
        if (this.filter != null) {
            hql.append(" filter (where ");
            this.filter.appendHqlString(hql, context);
            hql.append(')');
        }
    }
}

