/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SqmMutationStrategyHelper {
    private SqmMutationStrategyHelper() {
    }

    public static void visitCollectionTables(EntityMappingType entityDescriptor, Consumer<PluralAttributeMapping> consumer) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                consumer.accept((PluralAttributeMapping)attributeMapping);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTables((EmbeddedAttributeMapping)attributeMapping, consumer);
            }
        });
    }

    private static void visitCollectionTables(EmbeddedAttributeMapping attributeMapping, Consumer<PluralAttributeMapping> consumer) {
        attributeMapping.visitSubParts(modelPart -> {
            if (modelPart instanceof PluralAttributeMapping) {
                consumer.accept((PluralAttributeMapping)modelPart);
            } else if (modelPart instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTables((EmbeddedAttributeMapping)modelPart, consumer);
            }
        }, null);
    }

    public static void visitCollectionTableDeletes(EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions, Consumer<JdbcOperationQueryMutation> jdbcMutationConsumer) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTableDeletes((PluralAttributeMapping)attributeMapping, restrictionProducer, jdbcParameterBindings, queryOptions, jdbcMutationConsumer);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTableDeletes((EmbeddedAttributeMapping)attributeMapping, restrictionProducer, jdbcParameterBindings, queryOptions, jdbcMutationConsumer);
            }
        });
    }

    private static void visitCollectionTableDeletes(EmbeddedAttributeMapping attributeMapping, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions, Consumer<JdbcOperationQueryMutation> jdbcMutationConsumer) {
        attributeMapping.visitSubParts(modelPart -> {
            if (modelPart instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTableDeletes((PluralAttributeMapping)modelPart, restrictionProducer, jdbcParameterBindings, queryOptions, jdbcMutationConsumer);
            } else if (modelPart instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTableDeletes((EmbeddedAttributeMapping)modelPart, restrictionProducer, jdbcParameterBindings, queryOptions, jdbcMutationConsumer);
            }
        }, null);
    }

    private static void visitCollectionTableDeletes(PluralAttributeMapping attributeMapping, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions, Consumer<JdbcOperationQueryMutation> jdbcOperationConsumer) {
        String separateCollectionTable = attributeMapping.getSeparateCollectionTable();
        SessionFactoryImplementor sessionFactory = attributeMapping.getCollectionDescriptor().getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        if (separateCollectionTable != null) {
            NamedTableReference tableReference = new NamedTableReference(separateCollectionTable, "to_delete_", true);
            DeleteStatement sqlAstDelete = new DeleteStatement(tableReference, restrictionProducer.apply(tableReference, attributeMapping));
            jdbcOperationConsumer.accept(jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(sessionFactory, sqlAstDelete).translate(jdbcParameterBindings, queryOptions));
        }
    }

    public static boolean isId(JdbcMappingContainer type) {
        AttributeMapping attributeMapping;
        return type instanceof EntityIdentifierMapping || type instanceof AttributeMapping && SqmMutationStrategyHelper.isPartOfId(attributeMapping = (AttributeMapping)type);
    }

    public static boolean isPartOfId(AttributeMapping attributeMapping) {
        EmbeddableMappingType embeddableMappingType;
        ManagedMappingType managedMappingType = attributeMapping.getDeclaringType();
        return managedMappingType instanceof EmbeddableMappingType && ((embeddableMappingType = (EmbeddableMappingType)managedMappingType).getEmbeddedValueMapping().isEntityIdentifierMapping() || SqmMutationStrategyHelper.isId(embeddableMappingType.getEmbeddedValueMapping()));
    }

    public static void forEachSelectableMapping(String prefix, ModelPart modelPart, BiConsumer<String, SelectableMapping> consumer) {
        if (modelPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicModelPart = (BasicValuedModelPart)modelPart;
            if (basicModelPart.isInsertable()) {
                consumer.accept(prefix, basicModelPart);
            }
        } else if (modelPart instanceof EntityValuedModelPart) {
            Object object;
            int tableIndex;
            ToOneAttributeMapping toOneMapping;
            EntityPersister declaringEntityPersister;
            EntityValuedModelPart entityPart = (EntityValuedModelPart)modelPart;
            Association association = (Association)modelPart;
            if (association.getForeignKeyDescriptor() == null) {
                throw new IllegalStateException("ForeignKeyDescriptor not ready for [" + association.getPartName() + "] on entity: " + modelPart.findContainingEntityMapping().getEntityName());
            }
            if (association.getSideNature() != ForeignKeyDescriptor.Nature.KEY) {
                return;
            }
            if (association instanceof ToOneAttributeMapping && (declaringEntityPersister = (toOneMapping = (ToOneAttributeMapping)association).findContainingEntityMapping().getEntityPersister()).isInverseTable(tableIndex = SqmMutationStrategyHelper.findTableIndex(declaringEntityPersister, toOneMapping.getIdentifyingColumnsTableExpression()))) {
                return;
            }
            ValuedModelPart targetPart = association.getForeignKeyDescriptor().getTargetPart();
            if (targetPart instanceof AttributeMapping) {
                AttributeMapping attributeMapping = (AttributeMapping)targetPart;
                object = prefix + "_" + attributeMapping.getAttributeName();
            } else {
                object = prefix;
            }
            String newPrefix = object;
            SqmMutationStrategyHelper.forEachSelectableMapping(newPrefix, association.getForeignKeyDescriptor().getKeyPart(), consumer);
        } else if (modelPart instanceof DiscriminatedAssociationModelPart) {
            DiscriminatedAssociationModelPart discriminatedPart = (DiscriminatedAssociationModelPart)modelPart;
            String newPrefix = prefix + "_" + discriminatedPart.getPartName() + "_";
            SqmMutationStrategyHelper.forEachSelectableMapping(newPrefix + "discriminator", discriminatedPart.getDiscriminatorPart(), consumer);
            SqmMutationStrategyHelper.forEachSelectableMapping(newPrefix + "key", discriminatedPart.getKeyPart(), consumer);
        } else {
            EmbeddableValuedModelPart embeddablePart = (EmbeddableValuedModelPart)modelPart;
            AttributeMappingsList attributeMappings = embeddablePart.getEmbeddableTypeDescriptor().getAttributeMappings();
            if (attributeMappings.size() == 0) {
                throw new IllegalStateException("AttributeMappingsList not read yet on embeddable: " + String.valueOf(embeddablePart));
            }
            for (int i = 0; i < attributeMappings.size(); ++i) {
                AttributeMapping mapping = attributeMappings.get(i);
                if (mapping instanceof PluralAttributeMapping) continue;
                String newPrefix = modelPart.isVirtual() ? mapping.getAttributeName() : prefix + "_" + mapping.getAttributeName();
                SqmMutationStrategyHelper.forEachSelectableMapping(newPrefix, mapping, consumer);
            }
        }
    }

    public static void forEachSelectableMapping(String prefix, Value value, BiConsumer<String, Column> consumer) {
        if (value instanceof BasicValue || value instanceof Any.MetaValue || value instanceof Any.KeyValue) {
            assert (value.getSelectables().size() == 1);
            Selectable selectable = value.getSelectables().get(0);
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                if (value.isColumnInsertable(0)) {
                    consumer.accept(prefix, column);
                }
            }
        } else if (value instanceof DependantValue) {
            DependantValue dependantValue = (DependantValue)value;
            SqmMutationStrategyHelper.forEachSelectableMapping(prefix, dependantValue.getWrappedValue(), consumer);
        } else if (value instanceof ToOne) {
            String targetAttributeName;
            Value targetValue;
            OneToOne oneToOne;
            ToOne toOne = (ToOne)value;
            if (toOne instanceof OneToOne && (oneToOne = (OneToOne)toOne).getMappedByProperty() != null) {
                return;
            }
            PersistentClass targetEntity = toOne.getBuildingContext().getMetadataCollector().getEntityBinding(toOne.getReferencedEntityName());
            if (toOne.isReferenceToPrimaryKey()) {
                targetValue = targetEntity.getIdentifier();
                targetAttributeName = targetEntity.getIdentifierProperty() != null ? targetEntity.getIdentifierProperty().getName() : "id";
            } else {
                targetAttributeName = toOne.getReferencedPropertyName();
                targetValue = targetEntity.getReferencedProperty(toOne.getReferencedPropertyName()).getValue();
            }
            SqmMutationStrategyHelper.forEachSelectableMapping(prefix + "_" + targetAttributeName, targetValue, consumer);
        } else if (value instanceof Any) {
            Any any = (Any)value;
            SqmMutationStrategyHelper.forEachSelectableMapping(prefix + "_discriminator", any.getDiscriminatorDescriptor() != null ? any.getDiscriminatorDescriptor() : any.getMetaMapping(), consumer);
            SqmMutationStrategyHelper.forEachSelectableMapping(prefix + "_key", any.getKeyDescriptor() != null ? any.getKeyDescriptor() : any.getKeyMapping(), consumer);
        } else if (value instanceof Component) {
            Component component = (Component)value;
            int propertySpan = component.getPropertySpan();
            for (int i = 0; i < propertySpan; ++i) {
                Property property = component.getProperty(i);
                String newPrefix = component.isEmbedded() ? property.getName() : prefix + "_" + property.getName();
                SqmMutationStrategyHelper.forEachSelectableMapping(newPrefix, property.getValue(), consumer);
            }
        } else if (!(value instanceof OneToMany) && !(value instanceof Collection)) {
            throw new UnsupportedOperationException("Unsupported value type: " + String.valueOf(value.getClass()));
        }
    }

    private static int findTableIndex(EntityPersister declaringEntityPersister, String tableExpression) {
        String[] tableNames = declaringEntityPersister.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            if (!tableExpression.equals(tableNames[i])) continue;
            return i;
        }
        throw new IllegalStateException("Couldn't find table index for [" + tableExpression + "] in: " + declaringEntityPersister.getEntityName());
    }
}

