/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import org.hibernate.TransactionException;
import org.hibernate.resource.transaction.backend.jta.internal.JtaLogging;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionAdapter;
import org.hibernate.resource.transaction.backend.jta.internal.StatusTranslator;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class JtaTransactionAdapterUserTransactionImpl
implements JtaTransactionAdapter {
    private final UserTransaction userTransaction;
    private boolean initiator;

    public JtaTransactionAdapterUserTransactionImpl(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    @Override
    public void begin() {
        try {
            if (this.getStatus() == TransactionStatus.NOT_ACTIVE) {
                JtaLogging.JTA_LOGGER.callingUserTransactionBegin();
                this.userTransaction.begin();
                this.initiator = true;
                JtaLogging.JTA_LOGGER.calledUserTransactionBegin();
            } else {
                JtaLogging.JTA_LOGGER.skippingTransactionManagerBegin();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JTA UserTransaction.begin() failed", e);
        }
    }

    @Override
    public void commit() {
        try {
            if (this.initiator) {
                this.initiator = false;
                JtaLogging.JTA_LOGGER.callingUserTransactionCommit();
                this.userTransaction.commit();
                JtaLogging.JTA_LOGGER.calledUserTransactionCommit();
            } else {
                JtaLogging.JTA_LOGGER.skippingTransactionManagerCommit();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JTA UserTransaction.commit() failed", e);
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.initiator) {
                this.initiator = false;
                JtaLogging.JTA_LOGGER.callingUserTransactionRollback();
                this.userTransaction.rollback();
                JtaLogging.JTA_LOGGER.calledUserTransactionRollback();
            } else {
                this.markRollbackOnly();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JTA UserTransaction.rollback() failed", e);
        }
    }

    @Override
    public TransactionStatus getStatus() {
        try {
            TransactionStatus status = StatusTranslator.translate(this.userTransaction.getStatus());
            if (status == null) {
                throw new TransactionException("UserTransaction reported transaction status as unknown");
            }
            return status;
        }
        catch (SystemException e) {
            throw new TransactionException("JTA UserTransaction.getStatus() failed", e);
        }
    }

    @Override
    public void markRollbackOnly() {
        try {
            this.userTransaction.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to mark transaction for rollback only", e);
        }
    }

    @Override
    public void setTimeOut(int seconds) {
        if (seconds > 0) {
            try {
                this.userTransaction.setTransactionTimeout(seconds);
            }
            catch (SystemException e) {
                throw new TransactionException("Unable to apply requested transaction timeout", e);
            }
        }
    }
}

