/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.internal.AbstractBatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class BatchEntitySelectFetchInitializer
extends AbstractBatchEntitySelectFetchInitializer<BatchEntitySelectFetchInitializerData> {
    protected final AttributeMapping[] parentAttributes;
    protected final Setter referencedModelPartSetter;
    protected final Type referencedModelPartType;

    public BatchEntitySelectFetchInitializer(InitializerParent<?> parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(parentAccess, referencedModelPart, fetchedNavigable, concreteDescriptor, keyResult, affectedByFilter, creationState);
        this.parentAttributes = this.getParentEntityAttributes(referencedModelPart.getAttributeName());
        this.referencedModelPartSetter = referencedModelPart.getPropertyAccess().getSetter();
        this.referencedModelPartType = referencedModelPart.findContainingEntityMapping().getEntityPersister().getPropertyType(referencedModelPart.getAttributeName());
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new BatchEntitySelectFetchInitializerData(this, rowProcessingState);
    }

    @Override
    protected void registerResolutionListener(BatchEntitySelectFetchInitializerData data) {
        AttributeMapping parentAttribute;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object owningData = this.owningEntityInitializer.getData(rowProcessingState);
        HashMap<EntityKey, List<ParentInfo>> toBatchLoad = data.toBatchLoad;
        if (toBatchLoad == null) {
            toBatchLoad = data.toBatchLoad = new HashMap();
        }
        List parentInfos = toBatchLoad.computeIfAbsent(data.entityKey, key -> new ArrayList());
        if (((InitializerData)owningData).getState() != Initializer.State.INITIALIZED && (parentAttribute = this.parentAttributes[this.owningEntityInitializer.getConcreteDescriptor(owningData).getSubclassId()]) != null) {
            parentInfos.add(new ParentInfo(this.owningEntityInitializer.getTargetInstance(owningData), parentAttribute.getStateArrayPosition()));
        }
    }

    @Override
    public void endLoading(BatchEntitySelectFetchInitializerData data) {
        super.endLoading(data);
        HashMap<EntityKey, List<ParentInfo>> toBatchLoad = data.toBatchLoad;
        if (toBatchLoad != null) {
            SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            for (Map.Entry<EntityKey, List<ParentInfo>> entry : toBatchLoad.entrySet()) {
                EntityKey entityKey = entry.getKey();
                List<ParentInfo> parentInfos = entry.getValue();
                Object instance = BatchEntitySelectFetchInitializer.loadInstance(entityKey, this.toOneMapping, this.affectedByFilter, session);
                for (ParentInfo parentInfo : parentInfos) {
                    Object parentInstance = parentInfo.parentInstance;
                    EntityEntry entityEntry = persistenceContext.getEntry(parentInstance);
                    this.referencedModelPartSetter.set(parentInstance, instance);
                    Object[] loadedState = entityEntry.getLoadedState();
                    if (loadedState == null) continue;
                    loadedState[parentInfo.propertyIndex] = this.referencedModelPartType.deepCopy(instance, session.getFactory());
                }
            }
            data.toBatchLoad = null;
        }
    }

    @Override
    public String toString() {
        return "BatchEntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    public static class BatchEntitySelectFetchInitializerData
    extends AbstractBatchEntitySelectFetchInitializer.AbstractBatchEntitySelectFetchInitializerData {
        private HashMap<EntityKey, List<ParentInfo>> toBatchLoad;

        public BatchEntitySelectFetchInitializerData(BatchEntitySelectFetchInitializer initializer, RowProcessingState rowProcessingState) {
            super(initializer, rowProcessingState);
        }
    }

    private static class ParentInfo {
        private final Object parentInstance;
        private final int propertyIndex;

        public ParentInfo(Object parentInstance, int propertyIndex) {
            this.parentInstance = parentInstance;
            this.propertyIndex = propertyIndex;
        }
    }
}

