/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;

public class CapacityDependentDdlType
extends DdlTypeImpl {
    private final LobKind lobKind;
    private final TypeEntry[] typeEntries;

    private CapacityDependentDdlType(Builder builder) {
        super(builder.sqlTypeCode, builder.typeNamePattern, builder.castTypeNamePattern, builder.castTypeName, builder.dialect);
        this.lobKind = builder.lobKind;
        builder.typeEntries.sort(Comparator.naturalOrder());
        this.typeEntries = builder.typeEntries.toArray(new TypeEntry[0]);
    }

    @Override
    @Deprecated
    public String[] getRawTypeNames() {
        String[] rawTypeNames = new String[this.typeEntries.length + 1];
        for (int i = 0; i < this.typeEntries.length; ++i) {
            int parenEnd;
            String typeNamePattern = this.typeEntries[i].typeNamePattern;
            int paren = typeNamePattern.indexOf(40);
            rawTypeNames[i] = paren > 0 ? ((parenEnd = typeNamePattern.lastIndexOf(41)) + 1 == typeNamePattern.length() ? typeNamePattern.substring(0, paren) : typeNamePattern.substring(0, paren) + typeNamePattern.substring(parenEnd + 1)) : typeNamePattern;
        }
        rawTypeNames[this.typeEntries.length] = this.getRawTypeName();
        return rawTypeNames;
    }

    @Override
    public String getTypeName(Long size, Integer precision, Integer scale) {
        block3: {
            block2: {
                if (size == null || size <= 0L) break block2;
                for (TypeEntry typeEntry : this.typeEntries) {
                    if (size > typeEntry.capacity) continue;
                    return CapacityDependentDdlType.replace(typeEntry.typeNamePattern, size, precision, scale);
                }
                break block3;
            }
            if (precision == null || precision <= 0) break block3;
            for (TypeEntry typeEntry : this.typeEntries) {
                if ((long)precision.intValue() > typeEntry.capacity) continue;
                return CapacityDependentDdlType.replace(typeEntry.typeNamePattern, size, precision, scale);
            }
        }
        return super.getTypeName(size, precision, scale);
    }

    @Override
    public boolean isLob(Size size) {
        if (this.lobKind == LobKind.ALL_LOB) {
            return true;
        }
        Long length = size.getLength();
        if (length != null && length > 0L) {
            for (TypeEntry typeEntry : this.typeEntries) {
                if (length > typeEntry.capacity) continue;
                return false;
            }
        }
        return this.lobKind == LobKind.BIGGEST_LOB;
    }

    public static Builder builder(int sqlTypeCode, String typeNamePattern, Dialect dialect) {
        return CapacityDependentDdlType.builder(sqlTypeCode, JdbcType.isLob(sqlTypeCode) ? LobKind.ALL_LOB : LobKind.NONE, typeNamePattern, typeNamePattern, dialect);
    }

    public static Builder builder(int sqlTypeCode, LobKind lobKind, String typeNamePattern, Dialect dialect) {
        return CapacityDependentDdlType.builder(sqlTypeCode, lobKind, typeNamePattern, typeNamePattern, dialect);
    }

    public static Builder builder(int sqlTypeCode, String typeNamePattern, String castTypeName, Dialect dialect) {
        return CapacityDependentDdlType.builder(sqlTypeCode, JdbcType.isLob(sqlTypeCode) ? LobKind.ALL_LOB : LobKind.NONE, typeNamePattern, castTypeName, dialect);
    }

    public static Builder builder(int sqlTypeCode, LobKind lobKind, String typeNamePattern, String castTypeName, Dialect dialect) {
        return CapacityDependentDdlType.builder(sqlTypeCode, lobKind, typeNamePattern, null, castTypeName, dialect);
    }

    public static Builder builder(int sqlTypeCode, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
        return CapacityDependentDdlType.builder(sqlTypeCode, JdbcType.isLob(sqlTypeCode) ? LobKind.ALL_LOB : LobKind.NONE, typeNamePattern, castTypeNamePattern, castTypeName, dialect);
    }

    public static Builder builder(int sqlTypeCode, LobKind lobKind, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
        return new Builder(sqlTypeCode, lobKind, typeNamePattern, castTypeNamePattern, castTypeName, dialect);
    }

    public static class Builder {
        private final int sqlTypeCode;
        private final LobKind lobKind;
        private final String typeNamePattern;
        private final String castTypeNamePattern;
        private final String castTypeName;
        private final Dialect dialect;
        private final List<TypeEntry> typeEntries;

        private Builder(int sqlTypeCode, LobKind lobKind, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
            this.sqlTypeCode = sqlTypeCode;
            this.lobKind = lobKind;
            this.typeNamePattern = typeNamePattern;
            this.castTypeNamePattern = castTypeNamePattern;
            this.castTypeName = castTypeName;
            this.dialect = dialect;
            this.typeEntries = new ArrayList<TypeEntry>();
        }

        public Builder withTypeCapacity(long capacity, String typeNamePattern) {
            this.typeEntries.add(new TypeEntry(capacity, typeNamePattern));
            return this;
        }

        public CapacityDependentDdlType build() {
            return new CapacityDependentDdlType(this);
        }
    }

    public static enum LobKind {
        BIGGEST_LOB,
        ALL_LOB,
        NONE;

    }

    private static class TypeEntry
    implements Comparable<TypeEntry> {
        private final long capacity;
        private final String typeNamePattern;

        public TypeEntry(long capacity, String typeNamePattern) {
            this.capacity = capacity;
            this.typeNamePattern = typeNamePattern;
        }

        @Override
        public int compareTo(TypeEntry o) {
            return Long.compare(this.capacity, o.capacity);
        }
    }
}

