/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class WildcardType
extends Type {
    public static final WildcardType UNBOUNDED = new WildcardType(null, true);
    private final boolean isExtends;
    private final Type bound;
    private int hash;

    @Deprecated
    public static WildcardType create(Type bound, boolean isExtends) {
        return new WildcardType(bound, isExtends);
    }

    public static WildcardType createUpperBound(Type upperBound) {
        return new WildcardType(upperBound, true);
    }

    public static WildcardType createUpperBound(Class<?> upperBound) {
        return WildcardType.createUpperBound(ClassType.create(upperBound));
    }

    public static WildcardType createLowerBound(Type lowerBound) {
        return new WildcardType(lowerBound, false);
    }

    public static WildcardType createLowerBound(Class<?> lowerBound) {
        return WildcardType.createLowerBound(ClassType.create(lowerBound));
    }

    public static Builder builder() {
        return new Builder();
    }

    WildcardType(Type bound, boolean isExtends) {
        this(bound, isExtends, null);
    }

    WildcardType(Type bound, boolean isExtends, AnnotationInstance[] annotations) {
        super(DotName.OBJECT_NAME, annotations);
        this.bound = isExtends && bound == null ? ClassType.OBJECT_TYPE : bound;
        this.isExtends = isExtends;
    }

    @Override
    public DotName name() {
        if (this.isExtends && this.bound != null) {
            return this.bound.name();
        }
        return DotName.OBJECT_NAME;
    }

    public Type extendsBound() {
        return this.isExtends ? this.bound : ClassType.OBJECT_TYPE;
    }

    public Type superBound() {
        return this.isExtends ? null : this.bound;
    }

    Type bound() {
        return this.bound;
    }

    boolean isExtends() {
        return this.isExtends;
    }

    boolean hasImplicitObjectBound() {
        return this.isExtends && this.bound == ClassType.OBJECT_TYPE;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.WILDCARD_TYPE;
    }

    @Override
    public WildcardType asWildcardType() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return new WildcardType(this.bound, this.isExtends, newAnnotations);
    }

    @Override
    Type withoutAnnotations() {
        return new WildcardType(this.bound.withoutAnnotations(), this.isExtends, null);
    }

    Type copyType(Type bound) {
        return new WildcardType(bound, this.isExtends, this.annotationArray());
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        this.appendAnnotations(builder);
        builder.append('?');
        if (this.isExtends && this.bound != ClassType.OBJECT_TYPE) {
            builder.append(" extends ").append(this.bound.toString(true));
        }
        if (!this.isExtends && this.bound != null) {
            builder.append(" super ").append(this.bound.toString(true));
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        WildcardType other = (WildcardType)o;
        return this.isExtends == other.isExtends && this.bound.equals(other.bound);
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        hash = super.hashCode();
        hash = 31 * hash + (this.isExtends ? 1 : 0);
        this.hash = hash = 31 * hash + this.bound.hashCode();
        return this.hash;
    }

    @Override
    boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.internEquals(o)) {
            return false;
        }
        WildcardType other = (WildcardType)o;
        return this.isExtends == other.isExtends && this.bound.internEquals(other.bound);
    }

    @Override
    int internHashCode() {
        int hash = super.internHashCode();
        hash = 31 * hash + (this.isExtends ? 1 : 0);
        hash = 31 * hash + this.bound.internHashCode();
        return hash;
    }

    public static final class Builder
    extends Type.Builder<Builder> {
        private boolean isExtends = true;
        private Type bound;

        Builder() {
            super(DotName.OBJECT_NAME);
        }

        public Builder setUpperBound(Class<?> upperBound) {
            return this.setUpperBound(ClassType.create(upperBound));
        }

        public Builder setUpperBound(Type upperBound) {
            this.bound = upperBound;
            this.isExtends = true;
            return this;
        }

        public Builder setLowerBound(Class<?> lowerBound) {
            return this.setLowerBound(ClassType.create(lowerBound));
        }

        public Builder setLowerBound(Type lowerBound) {
            this.bound = lowerBound;
            this.isExtends = false;
            return this;
        }

        public WildcardType build() {
            return new WildcardType(this.bound, this.isExtends, this.annotationsArray());
        }
    }
}

