/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime;

import io.quarkus.kubernetes.service.binding.runtime.DatasourceServiceBindingConfigSourceFactory;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PostgreSQLServiceBindingConverter
implements ServiceBindingConverter {
    public static final String BINDING_TYPE = "postgresql";
    public static final String SSL_MODE = "sslmode";
    public static final String SSL_ROOT_CERT = "sslrootcert";
    public static final String OPTIONS = "options";

    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        return ServiceBinding.singleMatchingByType((String)BINDING_TYPE, serviceBindings).map(new PostgreSQLDatasourceServiceBindingConfigSourceFactory());
    }

    private static class PostgreSQLDatasourceServiceBindingConfigSourceFactory
    extends DatasourceServiceBindingConfigSourceFactory.Jdbc {
        private PostgreSQLDatasourceServiceBindingConfigSourceFactory() {
        }

        protected String formatUrl(String urlFormat, String type, String host, String database, String portPart) {
            Object result = super.formatUrl(urlFormat, type, host, database, portPart);
            Map sbProps = this.serviceBinding.getProperties();
            StringBuilder sslparam = new StringBuilder();
            String sslmode = sbProps.getOrDefault(PostgreSQLServiceBindingConverter.SSL_MODE, "");
            String sslRootCert = sbProps.getOrDefault(PostgreSQLServiceBindingConverter.SSL_ROOT_CERT, "");
            if (!"".equals(sslmode)) {
                sslparam.append(PostgreSQLServiceBindingConverter.SSL_MODE).append("=").append(sslmode);
            }
            if (!"".equals(sslRootCert)) {
                if (!"".equals(sslmode)) {
                    sslparam.append("&");
                }
                sslparam.append(PostgreSQLServiceBindingConverter.SSL_ROOT_CERT).append("=").append(this.serviceBinding.getBindingDirectory()).append(FileSystems.getDefault().getSeparator()).append(sslRootCert);
            }
            String options = sbProps.getOrDefault(PostgreSQLServiceBindingConverter.OPTIONS, "");
            Object crdbOption = "";
            ArrayList<CallSite> postgreOptions = new ArrayList<CallSite>();
            if (!options.equals("")) {
                String[] allOpts;
                for (String o : allOpts = options.split("&")) {
                    String[] keyval = o.split("=");
                    if (keyval.length != 2 || keyval[0].length() == 0 || keyval[1].length() == 0) continue;
                    if (keyval[0].equals("--cluster")) {
                        crdbOption = keyval[0] + "=" + keyval[1];
                        continue;
                    }
                    postgreOptions.add((CallSite)((Object)("-c " + keyval[0] + "=" + keyval[1])));
                }
            }
            Object combinedOptions = crdbOption;
            if (postgreOptions.size() > 0) {
                String otherOpts = String.join((CharSequence)" ", postgreOptions);
                combinedOptions = !((String)combinedOptions).equals("") ? (String)combinedOptions + " " + otherOpts : otherOpts;
            }
            try {
                combinedOptions = ((String)combinedOptions).length() > 0 ? "options=" + this.encode((String)combinedOptions).replace("+", "%20") : "";
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("failed to encode options params" + options, e);
            }
            if (sslparam.length() > 0 && !((String)combinedOptions).equals("")) {
                combinedOptions = String.valueOf(sslparam) + "&" + (String)combinedOptions;
            } else if (sslparam.length() > 0) {
                combinedOptions = sslparam.toString();
            }
            if (!"".equals(combinedOptions)) {
                result = (String)result + "?" + (String)combinedOptions;
            }
            return result;
        }

        private String encode(String str) throws UnsupportedEncodingException {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.toString());
        }
    }
}

