/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.PrintWriter;
import java.io.Writer;

public final class IndentWriter
extends PrintWriter {
    private static final int TAB_SIZE = 3;
    private static final String LOTS_OF_SPACES = " ".repeat(200);
    private int indent = 0;
    private boolean indentNeeded = false;

    public IndentWriter(Writer out) {
        super(out);
    }

    public IndentWriter inc() {
        ++this.indent;
        return this;
    }

    public IndentWriter dec() {
        if (this.indent == 0) {
            throw new IllegalStateException();
        }
        --this.indent;
        return this;
    }

    @Override
    public void write(int c) {
        if (this.indentNeeded) {
            super.write(LOTS_OF_SPACES, 0, this.indent * 3);
        }
        super.write(c);
        this.indentNeeded = c == 10;
    }

    @Override
    public void write(String s) {
        if (this.indentNeeded) {
            super.write(LOTS_OF_SPACES, 0, this.indent * 3);
        }
        if (s == null) {
            s = "null";
        }
        super.write(s, 0, s.length());
        this.indentNeeded = s.endsWith("\n");
    }

    @Override
    public IndentWriter append(CharSequence cs) {
        this.write(cs == null ? "null" : cs.toString());
        return this;
    }

    @Override
    public IndentWriter append(CharSequence cs, int start, int end) {
        if (cs == null) {
            cs = "null";
        }
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public IndentWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void println() {
        super.println();
        this.indentNeeded = true;
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        return super.printf(format, args);
    }
}

