/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ECUtil {
    public static final ECParameterSpec P_256_SPEC = ECUtil.createECParameterSpec("secp256r1");
    public static final ECParameterSpec P_384_SPEC = ECUtil.createECParameterSpec("secp384r1");
    public static final ECParameterSpec P_521_SPEC = ECUtil.createECParameterSpec("secp521r1");
    private static final SecureRandom secureRandom = new SecureRandom();

    private ECUtil() {
    }

    @NotNull
    public static byte[] createUncompressedPublicKey(@NotNull ECPublicKey ecPublicKey) {
        byte[] x = ArrayUtil.convertToFixedByteArray(ecPublicKey.getW().getAffineX());
        byte[] y = ArrayUtil.convertToFixedByteArray(ecPublicKey.getW().getAffineY());
        byte format = 4;
        return ByteBuffer.allocate(65).put(format).put(x).put(y).array();
    }

    @NotNull
    public static KeyPair createKeyPair() {
        return ECUtil.createKeyPair((byte[])null);
    }

    @NotNull
    public static PublicKey createPublicKey(@NotNull ECPublicKeySpec ecPublicKeySpec) {
        try {
            KeyFactory factory = KeyFactory.getInstance("EC");
            return factory.generatePublic(ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @NotNull
    public static PrivateKey createPrivateKey(@NotNull ECPrivateKeySpec ecPrivateKeySpec) {
        try {
            KeyFactory factory = KeyFactory.getInstance("EC");
            return factory.generatePrivate(ecPrivateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @NotNull
    private static KeyPairGenerator createKeyPairGenerator() {
        try {
            return KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @NotNull
    public static KeyPair createKeyPair(@Nullable byte[] seed, @NotNull ECParameterSpec ecParameterSpec) {
        KeyPairGenerator keyPairGenerator = ECUtil.createKeyPairGenerator();
        try {
            SecureRandom random;
            if (seed != null) {
                random = SecureRandom.getInstance("SHA1PRNG");
                random.setSeed(seed);
            } else {
                random = secureRandom;
            }
            keyPairGenerator.initialize(ecParameterSpec, random);
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @NotNull
    public static KeyPair createKeyPair(@Nullable byte[] seed) {
        return ECUtil.createKeyPair(seed, P_256_SPEC);
    }

    @NotNull
    public static KeyPair createKeyPair(@NotNull ECParameterSpec ecParameterSpec) {
        return ECUtil.createKeyPair(null, ecParameterSpec);
    }

    @NotNull
    public static PublicKey createPublicKeyFromUncompressed(@NotNull byte[] publicKey) {
        if (publicKey.length != 65) {
            throw new IllegalArgumentException("publicKey must be 65 bytes length");
        }
        return ECUtil.createPublicKey(Arrays.copyOfRange(publicKey, 1, 33), Arrays.copyOfRange(publicKey, 33, publicKey.length));
    }

    @NotNull
    private static PublicKey createPublicKey(@NotNull byte[] x, @NotNull byte[] y) {
        try {
            byte[] encodedPublicKey = ByteBuffer.allocate(1 + x.length + y.length).put(new byte[]{4}).put(x).put(y).array();
            ECPoint point = ECUtil.createECPoint(encodedPublicKey);
            return KeyFactory.getInstance("ECDSA").generatePublic(new ECPublicKeySpec(point, P_256_SPEC));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    @NotNull
    private static ECPoint createECPoint(@NotNull byte[] publicKey) {
        byte[] x = Arrays.copyOfRange(publicKey, 1, 33);
        byte[] y = Arrays.copyOfRange(publicKey, 33, 65);
        return new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
    }

    @NotNull
    private static ECParameterSpec createECParameterSpec(@NotNull String name) {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(name));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

