/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.constantpool.AnnotationConstantValueEntry;
import io.github.dmlloyd.classfile.constantpool.DoubleEntry;
import io.github.dmlloyd.classfile.constantpool.FloatEntry;
import io.github.dmlloyd.classfile.constantpool.IntegerEntry;
import io.github.dmlloyd.classfile.constantpool.LongEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AnnotationImpl;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AnnotationValue {
    public static final int TAG_BYTE = 66;
    public static final int TAG_CHAR = 67;
    public static final int TAG_DOUBLE = 68;
    public static final int TAG_FLOAT = 70;
    public static final int TAG_INT = 73;
    public static final int TAG_LONG = 74;
    public static final int TAG_SHORT = 83;
    public static final int TAG_BOOLEAN = 90;
    public static final int TAG_STRING = 115;
    public static final int TAG_ENUM = 101;
    public static final int TAG_CLASS = 99;
    public static final int TAG_ANNOTATION = 64;
    public static final int TAG_ARRAY = 91;

    public int tag();

    public static OfEnum ofEnum(Utf8Entry className, Utf8Entry constantName) {
        Objects.requireNonNull(className);
        Objects.requireNonNull(constantName);
        return new AnnotationImpl.OfEnumImpl(className, constantName);
    }

    public static OfEnum ofEnum(ClassDesc className, String constantName) {
        return AnnotationValue.ofEnum(TemporaryConstantPool.INSTANCE.utf8Entry(className), TemporaryConstantPool.INSTANCE.utf8Entry(constantName));
    }

    public static OfClass ofClass(Utf8Entry className) {
        Objects.requireNonNull(className);
        return new AnnotationImpl.OfClassImpl(className);
    }

    public static OfClass ofClass(ClassDesc className) {
        return AnnotationValue.ofClass(TemporaryConstantPool.INSTANCE.utf8Entry(className));
    }

    public static OfString ofString(Utf8Entry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfStringImpl(value);
    }

    public static OfString ofString(String value) {
        return AnnotationValue.ofString(TemporaryConstantPool.INSTANCE.utf8Entry(value));
    }

    public static OfDouble ofDouble(DoubleEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfDoubleImpl(value);
    }

    public static OfDouble ofDouble(double value) {
        return AnnotationValue.ofDouble(TemporaryConstantPool.INSTANCE.doubleEntry(value));
    }

    public static OfFloat ofFloat(FloatEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfFloatImpl(value);
    }

    public static OfFloat ofFloat(float value) {
        return AnnotationValue.ofFloat(TemporaryConstantPool.INSTANCE.floatEntry(value));
    }

    public static OfLong ofLong(LongEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfLongImpl(value);
    }

    public static OfLong ofLong(long value) {
        return AnnotationValue.ofLong(TemporaryConstantPool.INSTANCE.longEntry(value));
    }

    public static OfInt ofInt(IntegerEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfIntImpl(value);
    }

    public static OfInt ofInt(int value) {
        return AnnotationValue.ofInt(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfShort ofShort(IntegerEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfShortImpl(value);
    }

    public static OfShort ofShort(short value) {
        return AnnotationValue.ofShort(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfChar ofChar(IntegerEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfCharImpl(value);
    }

    public static OfChar ofChar(char value) {
        return AnnotationValue.ofChar(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfByte ofByte(IntegerEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfByteImpl(value);
    }

    public static OfByte ofByte(byte value) {
        return AnnotationValue.ofByte(TemporaryConstantPool.INSTANCE.intEntry(value));
    }

    public static OfBoolean ofBoolean(IntegerEntry value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfBooleanImpl(value);
    }

    public static OfBoolean ofBoolean(boolean value) {
        int i = value ? 1 : 0;
        return AnnotationValue.ofBoolean(TemporaryConstantPool.INSTANCE.intEntry(i));
    }

    public static OfAnnotation ofAnnotation(Annotation value) {
        Objects.requireNonNull(value);
        return new AnnotationImpl.OfAnnotationImpl(value);
    }

    public static OfArray ofArray(List<AnnotationValue> values) {
        return new AnnotationImpl.OfArrayImpl(values);
    }

    public static OfArray ofArray(AnnotationValue ... values) {
        return AnnotationValue.ofArray(List.of(values));
    }

    public static AnnotationValue of(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return AnnotationValue.ofString(s);
        }
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return AnnotationValue.ofByte(b);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return AnnotationValue.ofBoolean(b);
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return AnnotationValue.ofShort(s);
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return AnnotationValue.ofChar(c.charValue());
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return AnnotationValue.ofInt(i);
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return AnnotationValue.ofLong(l);
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return AnnotationValue.ofFloat(f.floatValue());
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return AnnotationValue.ofDouble(d);
        }
        if (value instanceof ClassDesc) {
            ClassDesc clsDesc = (ClassDesc)value;
            return AnnotationValue.ofClass(clsDesc);
        }
        if (value instanceof byte[]) {
            byte[] arr = (byte[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (byte el : arr) {
                els.add(AnnotationValue.ofByte(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof boolean[]) {
            boolean[] arr = (boolean[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (boolean el : arr) {
                els.add(AnnotationValue.ofBoolean(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof short[]) {
            short[] arr = (short[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (short el : arr) {
                els.add(AnnotationValue.ofShort(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof char[]) {
            char[] arr = (char[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (char el : arr) {
                els.add(AnnotationValue.ofChar(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof int[]) {
            int[] arr = (int[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (int el : arr) {
                els.add(AnnotationValue.ofInt(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof long[]) {
            long[] arr = (long[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (long el : arr) {
                els.add(AnnotationValue.ofLong(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof float[]) {
            float[] arr = (float[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (float el : arr) {
                els.add(AnnotationValue.ofFloat(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof double[]) {
            double[] arr = (double[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (double el : arr) {
                els.add(AnnotationValue.ofDouble(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            ArrayList<AnnotationValue> els = new ArrayList<AnnotationValue>(arr.length);
            for (Object el : arr) {
                els.add(AnnotationValue.of(el));
            }
            return AnnotationValue.ofArray(els);
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            return AnnotationValue.ofEnum(ClassDesc.ofDescriptor(e.getDeclaringClass().descriptorString()), e.name());
        }
        throw new IllegalArgumentException("Illegal annotation constant value type " + Objects.requireNonNull(value).getClass());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfEnum
    extends AnnotationValue {
        public Utf8Entry className();

        default public ClassDesc classSymbol() {
            return Util.fieldTypeSymbol(this.className());
        }

        public Utf8Entry constantName();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfClass
    extends AnnotationValue {
        public Utf8Entry className();

        default public ClassDesc classSymbol() {
            return Util.fieldTypeSymbol(this.className());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfString
    extends OfConstant {
        @Override
        public Utf8Entry constant();

        public String stringValue();

        default public String resolvedValue() {
            return this.stringValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfDouble
    extends OfConstant {
        @Override
        public DoubleEntry constant();

        public double doubleValue();

        @Override
        default public Double resolvedValue() {
            return this.doubleValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfFloat
    extends OfConstant {
        @Override
        public FloatEntry constant();

        public float floatValue();

        @Override
        default public Float resolvedValue() {
            return Float.valueOf(this.floatValue());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfLong
    extends OfConstant {
        @Override
        public LongEntry constant();

        public long longValue();

        @Override
        default public Long resolvedValue() {
            return this.longValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfInt
    extends OfConstant {
        @Override
        public IntegerEntry constant();

        public int intValue();

        @Override
        default public Integer resolvedValue() {
            return this.intValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfShort
    extends OfConstant {
        @Override
        public IntegerEntry constant();

        public short shortValue();

        @Override
        default public Short resolvedValue() {
            return this.shortValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfChar
    extends OfConstant {
        @Override
        public IntegerEntry constant();

        public char charValue();

        @Override
        default public Character resolvedValue() {
            return Character.valueOf(this.charValue());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfByte
    extends OfConstant {
        @Override
        public IntegerEntry constant();

        public byte byteValue();

        @Override
        default public Byte resolvedValue() {
            return this.byteValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfBoolean
    extends OfConstant {
        @Override
        public IntegerEntry constant();

        public boolean booleanValue();

        @Override
        default public Boolean resolvedValue() {
            return this.booleanValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfArray
    extends AnnotationValue {
        public List<AnnotationValue> values();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfConstant
    extends AnnotationValue {
        public AnnotationConstantValueEntry constant();

        public Constable resolvedValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfAnnotation
    extends AnnotationValue {
        public Annotation annotation();
    }
}

