/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeModel;
import io.github.dmlloyd.classfile.attribute.CodeAttribute;
import io.github.dmlloyd.classfile.impl.BufferedCodeBuilder;
import io.github.dmlloyd.classfile.impl.LabelContext;
import io.github.dmlloyd.classfile.impl.MethodInfo;
import io.github.dmlloyd.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TerminalCodeBuilder
extends CodeBuilder,
LabelContext {
    public int curTopLocal();

    public static int setupTopLocal(MethodInfo methodInfo, CodeModel original) {
        int paramSlots = Util.maxLocals(methodInfo.methodFlags(), methodInfo.methodTypeSymbol());
        if (original == null) {
            return paramSlots;
        }
        if (original instanceof CodeAttribute) {
            CodeAttribute attr = (CodeAttribute)original;
            return Math.max(paramSlots, attr.maxLocals());
        }
        if (original instanceof BufferedCodeBuilder.Model) {
            BufferedCodeBuilder.Model buffered = (BufferedCodeBuilder.Model)original;
            return Math.max(paramSlots, buffered.curTopLocal());
        }
        throw new InternalError("Unknown code model " + original);
    }
}

